/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.references;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.events.DocumentContextContentChangedEvent;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceIndex;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceIndexFiller;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.types.ModuleType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.Set;
import lombok.Generated;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ReferenceIndexFiller {
    private static final Set<ModuleType> DEFAULT_MODULE_TYPES = EnumSet.of(ModuleType.ManagerModule, ModuleType.CommonModule, ModuleType.UNKNOWN);
    private final ReferenceIndex index;

    @EventListener
    public void handleEvent(DocumentContextContentChangedEvent event) {
        DocumentContext documentContext = event.getSource();
        if (documentContext.isComputedDataFrozen()) {
            return;
        }
        this.fill(documentContext);
    }

    public void fill(DocumentContext documentContext) {
        this.index.clearReferences(documentContext.getUri());
        BSLParser.FileContext documentContextAst = documentContext.getAst();
        new MethodSymbolReferenceIndexFinder(this, documentContext).visitFile(documentContextAst);
        new VariableSymbolReferenceIndexFinder(this, documentContext).visitFile(documentContextAst);
    }

    @ConstructorProperties(value={"index"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ReferenceIndexFiller(ReferenceIndex index) {
        this.index = index;
    }
}

