/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.references;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.ServerContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.Symbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SymbolTree;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceFinder;
import com.github._1c_syntax.bsl.languageserver.references.model.OccurrenceType;
import com.github._1c_syntax.bsl.languageserver.references.model.Reference;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.springframework.stereotype.Component;

@Component
public class SourceDefinedSymbolDeclarationReferenceFinder
implements ReferenceFinder {
    private final ServerContext serverContext;

    public Optional<Reference> findReference(URI uri, Position position) {
        DocumentContext document = this.serverContext.getDocument(uri);
        if (document == null) {
            return Optional.empty();
        }
        SymbolTree symbolTree = document.getSymbolTree();
        return symbolTree.getChildrenFlat().stream().filter(sourceDefinedSymbol -> Ranges.containsPosition((Range)sourceDefinedSymbol.getSelectionRange(), (Position)position)).map(sourceDefinedSymbol -> new Reference((SourceDefinedSymbol)symbolTree.getModule(), (Symbol)sourceDefinedSymbol, uri, sourceDefinedSymbol.getSelectionRange(), OccurrenceType.DEFINITION)).findFirst();
    }

    @ConstructorProperties(value={"serverContext"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SourceDefinedSymbolDeclarationReferenceFinder(ServerContext serverContext) {
        this.serverContext = serverContext;
    }
}

