/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.references.model;

import com.github._1c_syntax.bsl.languageserver.references.model.SymbolOccurrence;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class LocationRepository {
    private final Map<URI, Set<SymbolOccurrence>> locations = new ConcurrentHashMap();

    public Stream<SymbolOccurrence> getSymbolOccurrencesByLocationUri(URI uri) {
        return this.locations.getOrDefault(uri, Collections.emptySet()).stream();
    }

    public void updateLocation(SymbolOccurrence symbolOccurrence) {
        this.locations.computeIfAbsent(symbolOccurrence.getLocation().getUri(), uri -> ConcurrentHashMap.newKeySet()).add(symbolOccurrence);
    }

    public void delete(URI uri) {
        this.locations.remove(uri);
    }
}

