/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.reporters;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticInfo;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.reporters.GenericIssueReport;
import com.github._1c_syntax.bsl.languageserver.reporters.data.AnalysisInfo;
import com.github._1c_syntax.bsl.languageserver.reporters.data.FileInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class GenericIssueReport {
    private static final Map<DiagnosticType, RuleType> diagnosticTypeRuleTypeMap = Map.of(DiagnosticType.ERROR, RuleType.BUG, DiagnosticType.CODE_SMELL, RuleType.CODE_SMELL, DiagnosticType.SECURITY_HOTSPOT, RuleType.SECURITY_HOTSPOT, DiagnosticType.VULNERABILITY, RuleType.VULNERABILITY);
    @JsonProperty(value="issues")
    private final List<GenericIssueEntry> issues;

    public GenericIssueReport(@JsonProperty(value="issues") List<GenericIssueEntry> issues) {
        this.issues = new ArrayList<GenericIssueEntry>(issues);
    }

    public GenericIssueReport(AnalysisInfo analysisInfo, Map<String, DiagnosticInfo> diagnosticInfos) {
        this.issues = new ArrayList();
        for (FileInfo fileInfo : analysisInfo.getFileinfos()) {
            for (Diagnostic diagnostic : fileInfo.getDiagnostics()) {
                GenericIssueEntry entry = new GenericIssueEntry(fileInfo.getPath().toString(), diagnostic, diagnosticInfos.get(DiagnosticCode.getStringValue((Either)diagnostic.getCode())));
                this.issues.add(entry);
            }
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<GenericIssueEntry> getIssues() {
        return this.issues;
    }
}

