/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.reporters;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.github._1c_syntax.bsl.languageserver.reporters.DiagnosticReporter;
import com.github._1c_syntax.bsl.languageserver.reporters.JUnitTestSuites;
import com.github._1c_syntax.bsl.languageserver.reporters.data.AnalysisInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.file.Path;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JUnitReporter
implements DiagnosticReporter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JUnitReporter.class);

    public String key() {
        return "junit";
    }

    public void report(AnalysisInfo analysisInfo, Path outputDir) {
        JUnitTestSuites jUnitReport = new JUnitTestSuites(analysisInfo);
        XmlMapper mapper = new XmlMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        File reportFile = new File(outputDir.toFile(), "./bsl-junit.xml");
        mapper.writeValue(reportFile, (Object)jUnitReport);
        LOGGER.info("JUnit report saved to {}", (Object)reportFile.getCanonicalPath());
    }
}

