/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.reporters.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.MetricStorage;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.utils.Absolute;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.lsp4j.Diagnostic;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class FileInfo {
    private final Path path;
    private final String mdoRef;
    private final List<Diagnostic> diagnostics;
    private final MetricStorage metrics;

    public FileInfo(String sourceDir, DocumentContext documentContext, List<Diagnostic> diagnostics) {
        URI uri = documentContext.getUri();
        this.path = Absolute.path((String)sourceDir).relativize(Absolute.path((URI)uri));
        this.diagnostics = new ArrayList<Diagnostic>(diagnostics);
        this.metrics = documentContext.getMetrics();
        Optional mdo = documentContext.getMdObject();
        this.mdoRef = mdo.isPresent() ? ((MD)mdo.get()).getMdoReference().getMdoRef() : "";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Path getPath() {
        return this.path;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getMdoRef() {
        return this.mdoRef;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MetricStorage getMetrics() {
        return this.metrics;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileInfo)) {
            return false;
        }
        FileInfo other = (FileInfo)o;
        Path this$path = this.getPath();
        Path other$path = other.getPath();
        if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
            return false;
        }
        String this$mdoRef = this.getMdoRef();
        String other$mdoRef = other.getMdoRef();
        if (this$mdoRef == null ? other$mdoRef != null : !this$mdoRef.equals(other$mdoRef)) {
            return false;
        }
        List this$diagnostics = this.getDiagnostics();
        List other$diagnostics = other.getDiagnostics();
        if (this$diagnostics == null ? other$diagnostics != null : !((Object)this$diagnostics).equals(other$diagnostics)) {
            return false;
        }
        MetricStorage this$metrics = this.getMetrics();
        MetricStorage other$metrics = other.getMetrics();
        return !(this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        String $mdoRef = this.getMdoRef();
        result = result * 59 + ($mdoRef == null ? 43 : $mdoRef.hashCode());
        List $diagnostics = this.getDiagnostics();
        result = result * 59 + ($diagnostics == null ? 43 : ((Object)$diagnostics).hashCode());
        MetricStorage $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "FileInfo(path=" + this.getPath() + ", mdoRef=" + this.getMdoRef() + ", diagnostics=" + this.getDiagnostics() + ", metrics=" + this.getMetrics() + ")";
    }

    @ConstructorProperties(value={"path", "mdoRef", "diagnostics", "metrics"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public FileInfo(Path path, String mdoRef, List<Diagnostic> diagnostics, MetricStorage metrics) {
        this.path = path;
        this.mdoRef = mdoRef;
        this.diagnostics = diagnostics;
        this.metrics = metrics;
    }
}

