/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.utils;

import java.util.HashSet;
import java.util.Set;

public abstract class AbstractObjectPool<T> {
    private final Set<T> available = new HashSet();
    private final Set<T> inUse = new HashSet();

    protected abstract T create();

    public synchronized T checkOut() {
        if (this.available.isEmpty()) {
            this.available.add(this.create());
        }
        Object instance = this.available.iterator().next();
        this.available.remove(instance);
        this.inUse.add(instance);
        return (T)instance;
    }

    public synchronized void checkIn(T instance) {
        this.inUse.remove(instance);
        this.available.add(instance);
    }

    public synchronized String toString() {
        return String.format("Pool available=%d inUse=%d", this.available.size(), this.inUse.size());
    }
}

