/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.utils;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.mdo.CommonModule;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.mdo.support.ScriptVariant;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.types.MDOType;
import com.github._1c_syntax.bsl.types.MdoReference;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.github._1c_syntax.utils.StringInterner;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

/*
 * Exception performing whole class analysis ignored.
 */
public final class MdoRefBuilder {
    private static final StringInterner stringInterner = new StringInterner();

    public static String getMdoRef(DocumentContext documentContext, BSLParser.CallStatementContext callStatement) {
        if (callStatement.globalMethodCall() != null) {
            return MdoRefBuilder.getMdoRef((DocumentContext)documentContext);
        }
        return MdoRefBuilder.getMdoRef((DocumentContext)documentContext, (TerminalNode)callStatement.IDENTIFIER(), (List)callStatement.modifier());
    }

    public static String getMdoRef(DocumentContext documentContext) {
        String mdoRef = documentContext.getMdObject().map(MD::getMdoReference).map(MdoReference::getMdoRef).orElseGet(() -> documentContext.getUri().toString());
        return stringInterner.intern(mdoRef);
    }

    public static String getMdoRef(DocumentContext documentContext, BSLParser.ComplexIdentifierContext complexIdentifier) {
        return MdoRefBuilder.getMdoRef((DocumentContext)documentContext, (TerminalNode)complexIdentifier.IDENTIFIER(), (List)complexIdentifier.modifier());
    }

    public static String getMdoRef(DocumentContext documentContext, @Nullable TerminalNode identifier, List<? extends BSLParser.ModifierContext> modifiers) {
        AtomicReference<String> mdoRef = new AtomicReference<String>("");
        Optional.ofNullable(identifier).map(ParseTree::getText).flatMap(commonModuleName -> MdoRefBuilder.getCommonModuleMdoRef((DocumentContext)documentContext, (String)commonModuleName)).or(() -> Optional.ofNullable(identifier).map(ParseTree::getText).flatMap(MDOType::fromValue).filter(mdoType -> ModuleType.byMDOType((MDOType)mdoType).contains(ModuleType.ManagerModule)).map(mdoType -> MdoRefBuilder.getMdoRef((MDOType)mdoType, (String)MdoRefBuilder.getMdoName((List)modifiers)))).ifPresent(mdoRef::set);
        return stringInterner.intern(mdoRef.get());
    }

    public static String getLocaleMdoRef(DocumentContext documentContext, MD mdo) {
        MdoReference mdoReference = mdo.getMdoReference();
        String result = documentContext.getServerContext().getConfiguration().getScriptVariant() == ScriptVariant.ENGLISH ? mdoReference.getMdoRef() : mdoReference.getMdoRefRu();
        return stringInterner.intern(result);
    }

    public static String getLocaleOwnerMdoName(DocumentContext documentContext, MD mdo) {
        String[] names = MdoRefBuilder.getLocaleMdoRef((DocumentContext)documentContext, (MD)mdo).split("\\.");
        if (names.length <= 1) {
            return "";
        }
        return stringInterner.intern(names[0].concat(".").concat(names[1]));
    }

    private static Optional<String> getCommonModuleMdoRef(DocumentContext documentContext, String commonModuleName) {
        return documentContext.getServerContext().getConfiguration().findCommonModule(commonModuleName).map(CommonModule::getMdoReference).map(MdoReference::getMdoRef);
    }

    private static String getMdoRef(MDOType mdoType, String identifier) {
        if (identifier.isEmpty()) {
            return "";
        }
        return mdoType.getName() + "." + identifier;
    }

    private static String getMdoName(List<? extends BSLParser.ModifierContext> modifiers) {
        return modifiers.stream().limit(1L).findAny().map(BSLParser.ModifierContext::accessProperty).map(BSLParser.AccessPropertyContext::IDENTIFIER).map(ParseTree::getText).orElse("");
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private MdoRefBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

