/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.utils;

import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.Generated;

public final class NotifyDescription {
    private static final Pattern NOTIFY_DESCRIPTION = CaseInsensitivePattern.compile((String)"^(\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u041e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u044f|NotifyDescription)$");
    private static final int MIN_PARAM_LIST_SIZE = 1;
    private static final int FULL_PARAM_LIST_SIZE = 5;
    public static final int HANDLER_INDEX = 0;
    public static final int HANDLER_MODULE_INDEX = 1;
    public static final int HANDLER_ERROR_INDEX = 3;
    public static final int HANDLER_ERROR_MODULE_INDEX = 4;

    public static boolean isNotifyDescription(BSLParser.NewExpressionContext newExpression) {
        Optional<String> result = Optional.of(newExpression).map(BSLParser.NewExpressionContext::typeName).map(BSLParserRuleContext::getText).filter(t -> NOTIFY_DESCRIPTION.matcher((CharSequence)t).find());
        return result.isPresent();
    }

    public static boolean notifyDescriptionContainsHandler(Collection<?> callParamList) {
        return callParamList.size() > 1;
    }

    public static boolean notifyDescriptionContainsErrorHandler(Collection<?> callParamList) {
        return callParamList.size() == 5;
    }

    public static Optional<BSLParser.MemberContext> getFirstMember(BSLParser.CallParamContext callParamContext) {
        return Optional.ofNullable(callParamContext.expression()).map(BSLParser.ExpressionContext::member).filter(Predicate.not(List::isEmpty)).map(member -> (BSLParser.MemberContext)member.get(0));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private NotifyDescription() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

