/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.utils;

import com.github._1c_syntax.bsl.languageserver.utils.Regions;
import com.github._1c_syntax.bsl.mdo.support.ScriptVariant;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Regions {
    private static final Pattern PUBLIC_REGION_NAME = Regions.createPattern((String)"\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441", (String)"Public");
    private static final Pattern INTERNAL_REGION_NAME = Regions.createPattern((String)"\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0439\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441", (String)"Internal");
    private static final Pattern PRIVATE_REGION_NAME = Regions.createPattern((String)"\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0435\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b\u0418\u0424\u0443\u043d\u043a\u0446\u0438\u0438", (String)"Private");
    private static final Pattern EVENT_HANDLERS_REGION_NAME = Regions.createPattern((String)"\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u0421\u043e\u0431\u044b\u0442\u0438\u0439", (String)"EventHandlers");
    private static final Pattern FORM_EVENT_HANDLERS_REGION_NAME = Regions.createPattern((String)"\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u0421\u043e\u0431\u044b\u0442\u0438\u0439\u0424\u043e\u0440\u043c\u044b", (String)"FormEventHandlers");
    private static final Pattern FORM_HEADER_ITEMS_EVENT_HANDLERS_REGION_NAME = Regions.createPattern((String)"\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u0421\u043e\u0431\u044b\u0442\u0438\u0439\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432\u0428\u0430\u043f\u043a\u0438\u0424\u043e\u0440\u043c\u044b", (String)"FormHeaderItemsEventHandlers");
    private static final Pattern FORM_TABLE_ITEMS_EVENT_HANDLERS_REGION_NAME = Regions.createPattern((String)"\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u0421\u043e\u0431\u044b\u0442\u0438\u0439\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432\u0422\u0430\u0431\u043b\u0438\u0446\u044b\u0424\u043e\u0440\u043c\u044b", (String)"FormTableItemsEventHandlers", (String)"^(?:%s|%s)[\\w\u0430-\u044f\u0451\u0401]*$");
    private static final Pattern FORM_COMMANDS_EVENT_HANDLERS_REGION_NAME = Regions.createPattern((String)"\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u041a\u043e\u043c\u0430\u043d\u0434\u0424\u043e\u0440\u043c\u044b", (String)"FormCommandsEventHandlers");
    private static final Pattern VARIABLES_REGION_NAME = Regions.createPattern((String)"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445", (String)"Variables");
    private static final Pattern INITIALIZE_REGION_NAME = Regions.createPattern((String)"\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f", (String)"Initialize");

    public static Set<Pattern> getStandardRegionsPatternsByModuleType(ModuleType moduleType) {
        if (moduleType == ModuleType.UNKNOWN) {
            return Collections.emptySet();
        }
        HashSet<Pattern> standardRegions = new HashSet<Pattern>();
        switch (1.$SwitchMap$com$github$_1c_syntax$bsl$types$ModuleType[moduleType.ordinal()]) {
            case 1: {
                Regions.addFormModuleRegions(standardRegions);
                break;
            }
            case 2: 
            case 3: {
                Regions.addRecordSetRegions(standardRegions);
                break;
            }
            case 4: {
                standardRegions.add(VARIABLES_REGION_NAME);
                standardRegions.add(PUBLIC_REGION_NAME);
                standardRegions.add(EVENT_HANDLERS_REGION_NAME);
                standardRegions.add(INTERNAL_REGION_NAME);
                break;
            }
            case 5: {
                standardRegions.add(PUBLIC_REGION_NAME);
                standardRegions.add(INTERNAL_REGION_NAME);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                standardRegions.add(VARIABLES_REGION_NAME);
                standardRegions.add(PUBLIC_REGION_NAME);
                standardRegions.add(EVENT_HANDLERS_REGION_NAME);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                standardRegions.add(EVENT_HANDLERS_REGION_NAME);
                break;
            }
            case 13: {
                standardRegions.add(PUBLIC_REGION_NAME);
                standardRegions.add(EVENT_HANDLERS_REGION_NAME);
                break;
            }
            case 14: {
                standardRegions.add(PUBLIC_REGION_NAME);
                standardRegions.add(EVENT_HANDLERS_REGION_NAME);
                standardRegions.add(INTERNAL_REGION_NAME);
                break;
            }
        }
        standardRegions.add(PRIVATE_REGION_NAME);
        return standardRegions;
    }

    public static Set<String> getOneScriptStandardRegions(ScriptVariant configurationLanguage) {
        LinkedHashSet<String> regionsName = new LinkedHashSet<String>();
        if (configurationLanguage == ScriptVariant.ENGLISH) {
            regionsName.add("Variables");
            regionsName.add("Public");
            regionsName.add("Internal");
            regionsName.add("Private");
            return regionsName;
        }
        regionsName.add("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445");
        regionsName.add("\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
        regionsName.add("\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0439\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
        regionsName.add("\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0435\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b\u0418\u0424\u0443\u043d\u043a\u0446\u0438\u0438");
        return regionsName;
    }

    public static Set<String> getStandardRegionsNamesByModuleType(ModuleType moduleType, ScriptVariant language) {
        return Regions.getStandardRegionNames((ModuleType)moduleType, (ScriptVariant)language);
    }

    private static Set<String> getStandardRegionNames(ModuleType moduleType, ScriptVariant language) {
        LinkedHashSet<String> regionsName = new LinkedHashSet<String>();
        switch (1.$SwitchMap$com$github$_1c_syntax$bsl$types$ModuleType[moduleType.ordinal()]) {
            case 1: {
                Regions.addFormModuleRegionsNames(regionsName, (ScriptVariant)language);
                break;
            }
            case 2: 
            case 3: {
                Regions.addObjectAndRecordSetRegionsName(regionsName, (ScriptVariant)language);
                break;
            }
            case 4: {
                Regions.addValueManageRegionsName(regionsName, (ScriptVariant)language);
                break;
            }
            case 5: {
                Regions.addCommonModuleRegionNames(regionsName, (ScriptVariant)language);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                Regions.addApplicationModulesRegionsNames(regionsName, (ScriptVariant)language);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                Regions.addCommandAndSessionModulesRegionsNames(regionsName, (ScriptVariant)language);
                break;
            }
            case 13: {
                Regions.addExternalConnectionRegionsNames(regionsName, (ScriptVariant)language);
                break;
            }
            case 14: {
                Regions.addManagerModuleRegionsNames(regionsName, (ScriptVariant)language);
                break;
            }
        }
        regionsName.add(language == ScriptVariant.ENGLISH ? "Private" : "\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0435\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b\u0418\u0424\u0443\u043d\u043a\u0446\u0438\u0438");
        return regionsName;
    }

    private static void addManagerModuleRegionsNames(Set<String> regionsName, ScriptVariant language) {
        if (language == ScriptVariant.ENGLISH) {
            regionsName.add("Public");
            regionsName.add("EventHandlers");
            regionsName.add("Internal");
            return;
        }
        regionsName.add("\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
        regionsName.add("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u0421\u043e\u0431\u044b\u0442\u0438\u0439");
        regionsName.add("\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0439\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
    }

    private static void addExternalConnectionRegionsNames(Set<String> regionsName, ScriptVariant language) {
        if (language == ScriptVariant.ENGLISH) {
            regionsName.add("Public");
            regionsName.add("EventHandlers");
            return;
        }
        regionsName.add("\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
        regionsName.add("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u0421\u043e\u0431\u044b\u0442\u0438\u0439");
    }

    private static void addCommandAndSessionModulesRegionsNames(Set<String> regionsName, ScriptVariant language) {
        regionsName.add(language == ScriptVariant.ENGLISH ? "EventHandlers" : "\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u0421\u043e\u0431\u044b\u0442\u0438\u0439");
    }

    private static void addApplicationModulesRegionsNames(Set<String> regionsName, ScriptVariant language) {
        if (language == ScriptVariant.ENGLISH) {
            regionsName.add("Variables");
            regionsName.add("Public");
            regionsName.add("EventHandlers");
            return;
        }
        regionsName.add("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445");
        regionsName.add("\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
        regionsName.add("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u0421\u043e\u0431\u044b\u0442\u0438\u0439");
    }

    private static void addCommonModuleRegionNames(Set<String> regionsName, ScriptVariant language) {
        if (language == ScriptVariant.ENGLISH) {
            regionsName.add("Public");
            regionsName.add("Internal");
            return;
        }
        regionsName.add("\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
        regionsName.add("\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0439\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
    }

    private static void addValueManageRegionsName(Set<String> regionsName, ScriptVariant language) {
        if (language == ScriptVariant.ENGLISH) {
            regionsName.add("Variables");
            regionsName.add("Public");
            regionsName.add("EventHandlers");
            regionsName.add("Internal");
            return;
        }
        regionsName.add("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445");
        regionsName.add("\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
        regionsName.add("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u0421\u043e\u0431\u044b\u0442\u0438\u0439");
        regionsName.add("\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0439\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
    }

    private static void addObjectAndRecordSetRegionsName(Set<String> regionsName, ScriptVariant language) {
        if (language == ScriptVariant.ENGLISH) {
            regionsName.add("Variables");
            regionsName.add("Public");
            regionsName.add("EventHandlers");
            regionsName.add("Internal");
            regionsName.add("Initialize");
            return;
        }
        regionsName.add("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445");
        regionsName.add("\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
        regionsName.add("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u0421\u043e\u0431\u044b\u0442\u0438\u0439");
        regionsName.add("\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0439\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
        regionsName.add("\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f");
    }

    private static void addFormModuleRegionsNames(Set<String> regionsName, ScriptVariant language) {
        if (language == ScriptVariant.ENGLISH) {
            regionsName.add("Variables");
            regionsName.add("FormEventHandlers");
            regionsName.add("FormHeaderItemsEventHandlers");
            regionsName.add("FormTableItemsEventHandlers");
            regionsName.add("FormCommandsEventHandlers");
            regionsName.add("Initialize");
            return;
        }
        regionsName.add("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445");
        regionsName.add("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u0421\u043e\u0431\u044b\u0442\u0438\u0439\u0424\u043e\u0440\u043c\u044b");
        regionsName.add("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u0421\u043e\u0431\u044b\u0442\u0438\u0439\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432\u0428\u0430\u043f\u043a\u0438\u0424\u043e\u0440\u043c\u044b");
        regionsName.add("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u0421\u043e\u0431\u044b\u0442\u0438\u0439\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432\u0422\u0430\u0431\u043b\u0438\u0446\u044b\u0424\u043e\u0440\u043c\u044b");
        regionsName.add("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u041a\u043e\u043c\u0430\u043d\u0434\u0424\u043e\u0440\u043c\u044b");
        regionsName.add("\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f");
    }

    private static void addRecordSetRegions(Set<Pattern> standardRegions) {
        standardRegions.add(VARIABLES_REGION_NAME);
        standardRegions.add(PUBLIC_REGION_NAME);
        standardRegions.add(EVENT_HANDLERS_REGION_NAME);
        standardRegions.add(INTERNAL_REGION_NAME);
        standardRegions.add(INITIALIZE_REGION_NAME);
    }

    private static void addFormModuleRegions(Set<Pattern> standardRegions) {
        standardRegions.add(VARIABLES_REGION_NAME);
        standardRegions.add(FORM_EVENT_HANDLERS_REGION_NAME);
        standardRegions.add(FORM_HEADER_ITEMS_EVENT_HANDLERS_REGION_NAME);
        standardRegions.add(FORM_TABLE_ITEMS_EVENT_HANDLERS_REGION_NAME);
        standardRegions.add(FORM_COMMANDS_EVENT_HANDLERS_REGION_NAME);
        standardRegions.add(INITIALIZE_REGION_NAME);
    }

    private static Pattern createPattern(String keywordRu, String keywordEn) {
        return Regions.createPattern((String)keywordRu, (String)keywordEn, (String)"^(?:%s|%s)$");
    }

    private static Pattern createPattern(String keywordRu, String keywordEn, String template) {
        return CaseInsensitivePattern.compile((String)String.format(template, keywordRu, keywordEn));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Regions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

