/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.utils.expressiontree;

import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.AbstractCallNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BinaryOperationNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BslExpression;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BslOperator;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.ConstructorCallNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.ExpressionParseTreeRewriter;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.ExpressionTreeBuildingVisitor;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.MethodCallNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.SkippedCallArgumentNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.TerminalSymbolNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.TernaryOperatorNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.UnaryOperationNode;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserBaseVisitor;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;

/*
 * Exception performing whole class analysis ignored.
 */
class ExpressionTreeBuildingVisitor
extends BSLParserBaseVisitor<ParseTree> {
    private final Deque<BslExpression> operands = new ArrayDeque();
    private final Deque<OperatorInCode> operatorsInFly = new ArrayDeque();
    private BslExpression resultExpression;
    private int recursionLevel = -1;

    ExpressionTreeBuildingVisitor() {
    }

    public BslExpression getExpressionTree() {
        return this.resultExpression;
    }

    public ParseTree visitExpression(BSLParser.ExpressionContext ctx) {
        boolean addToOperands;
        int nestingCount = this.operatorsInFly.size();
        ++this.recursionLevel;
        this.visitMember(ctx.member(0));
        int count = ctx.getChildCount();
        if (count > 1) {
            for (int i = 1; i < count; ++i) {
                ParseTree child = ctx.getChild(i);
                if (child.getClass() == BSLParser.OperationContext.class) {
                    this.visitOperation((BSLParser.OperationContext)child);
                    continue;
                }
                if (child.getClass() == BSLParser.MemberContext.class) {
                    this.visitMember((BSLParser.MemberContext)child);
                    continue;
                }
                if (child.getClass() == BSLParser.PreprocessorContext.class) continue;
                throw new IllegalStateException();
            }
        }
        boolean bl = addToOperands = this.recursionLevel > 0;
        while (nestingCount < this.operatorsInFly.size()) {
            this.buildOperation();
        }
        BslExpression operation = (BslExpression)this.operands.peek();
        assert (operation != null);
        if (operation.getRepresentingAst() == null) {
            operation.setRepresentingAst((ParseTree)ctx);
        }
        if (!addToOperands) {
            this.resultExpression = (BslExpression)this.operands.pop();
        }
        --this.recursionLevel;
        return ctx;
    }

    public ParseTree visitMember(BSLParser.MemberContext ctx) {
        ParseTree dispatchChild;
        BSLParser.UnaryModifierContext unaryModifier = ctx.unaryModifier();
        int childIndex = 0;
        if (unaryModifier != null) {
            this.visitUnaryModifier(unaryModifier);
            childIndex = 1;
        }
        if ((dispatchChild = ctx.getChild(childIndex)) instanceof TerminalNode) {
            int token = ((TerminalNode)dispatchChild).getSymbol().getType();
            switch (token) {
                case 6: {
                    this.visitParenthesis(ctx.expression(), ctx.modifier());
                    break;
                }
                case 126: {
                    this.visitAwaitedMember(ctx.getChild(childIndex + 1));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected rule " + dispatchChild);
                }
            }
        } else {
            dispatchChild.accept((ParseTreeVisitor)this);
        }
        if (unaryModifier != null) {
            this.buildOperation();
        }
        return ctx;
    }

    private void visitParenthesis(BSLParser.ExpressionContext expression, List<? extends BSLParser.ModifierContext> modifiers) {
        BslExpression subExpr = ExpressionTreeBuildingVisitor.makeSubexpression((BSLParser.ExpressionContext)expression);
        this.operands.push(subExpr);
        for (BSLParser.ModifierContext modifierContext : modifiers) {
            modifierContext.accept((ParseTreeVisitor)this);
        }
    }

    private void visitAwaitedMember(ParseTree child) {
        child.accept((ParseTreeVisitor)this);
    }

    public ParseTree visitOperation(BSLParser.OperationContext ctx) {
        BslOperator operator = ExpressionTreeBuildingVisitor.getOperator((BSLParser.OperationContext)ctx);
        this.processOperation(new OperatorInCode(operator, (ParseTree)ctx));
        return ctx;
    }

    private void processOperation(OperatorInCode operator) {
        if (this.operatorsInFly.isEmpty()) {
            this.operatorsInFly.push(operator);
            return;
        }
        OperatorInCode lastSeenOperator = (OperatorInCode)this.operatorsInFly.peek();
        if (lastSeenOperator.getPriority() > operator.getPriority()) {
            this.buildOperation();
        }
        this.operatorsInFly.push(operator);
    }

    private static BslOperator getOperator(BSLParser.OperationContext ctx) {
        if (ctx.PLUS() != null) {
            return BslOperator.ADD;
        }
        if (ctx.MINUS() != null) {
            return BslOperator.SUBTRACT;
        }
        if (ctx.MUL() != null) {
            return BslOperator.MULTIPLY;
        }
        if (ctx.QUOTIENT() != null) {
            return BslOperator.DIVIDE;
        }
        if (ctx.MODULO() != null) {
            return BslOperator.MODULO;
        }
        if (ctx.boolOperation() != null) {
            if (ctx.boolOperation().AND_KEYWORD() != null) {
                return BslOperator.AND;
            }
            return BslOperator.OR;
        }
        if (ctx.compareOperation() != null) {
            int token = ((TerminalNode)ctx.compareOperation().getChild(0)).getSymbol().getType();
            switch (token) {
                case 11: {
                    return BslOperator.EQUAL;
                }
                case 15: {
                    return BslOperator.NOT_EQUAL;
                }
                case 16: {
                    return BslOperator.LESS;
                }
                case 14: {
                    return BslOperator.LESS_OR_EQUAL;
                }
                case 18: {
                    return BslOperator.GREATER;
                }
                case 17: {
                    return BslOperator.GREATER_OR_EQUAL;
                }
            }
        }
        throw new IllegalStateException();
    }

    public ParseTree visitConstValue(BSLParser.ConstValueContext ctx) {
        TerminalSymbolNode node = TerminalSymbolNode.literal((BSLParser.ConstValueContext)ctx);
        this.operands.push(node);
        return ctx;
    }

    public ParseTree visitUnaryModifier(BSLParser.UnaryModifierContext ctx) {
        TerminalNode child = (TerminalNode)ctx.getChild(0);
        int token = child.getSymbol().getType();
        this.operatorsInFly.push(new OperatorInCode(switch (token) {
            case 12 -> BslOperator.UNARY_PLUS;
            case 13 -> BslOperator.UNARY_MINUS;
            case 66 -> BslOperator.NOT;
            default -> throw new IllegalArgumentException();
        }, (ParseTree)child));
        return ctx;
    }

    public ParseTree visitComplexIdentifier(BSLParser.ComplexIdentifierContext ctx) {
        if (ctx.IDENTIFIER() != null) {
            this.operands.push(TerminalSymbolNode.identifier((TerminalNode)ctx.IDENTIFIER()));
        } else {
            ParseTree childVariant = (ParseTree)ctx.children.get(0);
            childVariant.accept((ParseTreeVisitor)this);
        }
        List modifiers = ctx.modifier();
        for (BSLParser.ModifierContext modifier : modifiers) {
            modifier.accept((ParseTreeVisitor)this);
        }
        return ctx;
    }

    public ParseTree visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        TerminalNode name = ctx.methodName().IDENTIFIER();
        MethodCallNode callNode = MethodCallNode.create((TerminalNode)name);
        callNode.setRepresentingAst((ParseTree)ctx);
        BSLParser.CallParamListContext paramList = ctx.doCall().callParamList();
        List parameters = paramList.callParam();
        ExpressionTreeBuildingVisitor.addCallArguments((AbstractCallNode)callNode, (List)parameters);
        this.operands.push(callNode);
        return ctx;
    }

    public ParseTree visitNewExpression(BSLParser.NewExpressionContext ctx) {
        ConstructorCallNode callNode;
        BSLParser.TypeNameContext typeName = ctx.typeName();
        BSLParser.DoCallContext call = ctx.doCall();
        List args = call == null ? Collections.emptyList() : ctx.doCall().callParamList().callParam();
        if (typeName == null) {
            BSLParser.CallParamContext typeNameArg = (BSLParser.CallParamContext)args.get(0);
            args = args.stream().skip(1L).collect(Collectors.toList());
            callNode = ConstructorCallNode.createDynamic((BslExpression)ExpressionTreeBuildingVisitor.makeSubexpression((BSLParser.ExpressionContext)typeNameArg.expression()));
        } else {
            TerminalSymbolNode typeNameTerminal = TerminalSymbolNode.literal((TerminalNode)typeName.IDENTIFIER());
            callNode = ConstructorCallNode.createStatic((TerminalSymbolNode)typeNameTerminal);
        }
        callNode.setRepresentingAst((ParseTree)ctx);
        ExpressionTreeBuildingVisitor.addCallArguments((AbstractCallNode)callNode, args);
        this.operands.push(callNode);
        return ctx;
    }

    public ParseTree visitAccessProperty(BSLParser.AccessPropertyContext ctx) {
        BslExpression target = (BslExpression)this.operands.pop();
        BinaryOperationNode operation = BinaryOperationNode.create((BslOperator)BslOperator.DEREFERENCE, (BslExpression)target, (BslExpression)TerminalSymbolNode.identifier((TerminalNode)ctx.IDENTIFIER()), (ParseTree)ctx);
        this.operands.push(operation);
        return ctx;
    }

    public ParseTree visitAccessIndex(BSLParser.AccessIndexContext ctx) {
        BslExpression target = (BslExpression)this.operands.pop();
        BslExpression expressionArg = ExpressionTreeBuildingVisitor.makeSubexpression((BSLParser.ExpressionContext)ctx.expression());
        BinaryOperationNode indexOperation = BinaryOperationNode.create((BslOperator)BslOperator.INDEX_ACCESS, (BslExpression)target, (BslExpression)expressionArg, (ParseTree)ctx);
        this.operands.push(indexOperation);
        return ctx;
    }

    public ParseTree visitAccessCall(BSLParser.AccessCallContext ctx) {
        BslExpression target = (BslExpression)this.operands.pop();
        BSLParser.MethodCallContext methodCall = ctx.methodCall();
        MethodCallNode callNode = MethodCallNode.create((TerminalNode)methodCall.methodName().IDENTIFIER());
        ExpressionTreeBuildingVisitor.addCallArguments((AbstractCallNode)callNode, (List)methodCall.doCall().callParamList().callParam());
        BinaryOperationNode operation = BinaryOperationNode.create((BslOperator)BslOperator.DEREFERENCE, (BslExpression)target, (BslExpression)callNode, (ParseTree)ctx);
        this.operands.push(operation);
        return ctx;
    }

    public ParseTree visitTernaryOperator(BSLParser.TernaryOperatorContext ctx) {
        TernaryOperatorNode ternary = TernaryOperatorNode.create((BslExpression)ExpressionTreeBuildingVisitor.makeSubexpression((BSLParser.ExpressionContext)ctx.expression(0)), (BslExpression)ExpressionTreeBuildingVisitor.makeSubexpression((BSLParser.ExpressionContext)ctx.expression(1)), (BslExpression)ExpressionTreeBuildingVisitor.makeSubexpression((BSLParser.ExpressionContext)ctx.expression(2)));
        ternary.setRepresentingAst((ParseTree)ctx);
        this.operands.push(ternary);
        return ctx;
    }

    private static BslExpression makeSubexpression(BSLParser.ExpressionContext ctx) {
        return ExpressionParseTreeRewriter.buildExpressionTree((BSLParser.ExpressionContext)ctx);
    }

    private static void addCallArguments(AbstractCallNode callNode, List<? extends BSLParser.CallParamContext> args) {
        for (BSLParser.CallParamContext callParamContext : args) {
            if (callParamContext.expression() == null) {
                callNode.addArgument((BslExpression)new SkippedCallArgumentNode());
                continue;
            }
            callNode.addArgument(ExpressionTreeBuildingVisitor.makeSubexpression((BSLParser.ExpressionContext)callParamContext.expression()));
        }
    }

    private void buildOperation() {
        if (this.operatorsInFly.isEmpty()) {
            return;
        }
        OperatorInCode operator = (OperatorInCode)this.operatorsInFly.pop();
        switch (1.$SwitchMap$com$github$_1c_syntax$bsl$languageserver$utils$expressiontree$BslOperator[operator.getOperator().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                BslExpression operand = (BslExpression)this.operands.pop();
                UnaryOperationNode operation = UnaryOperationNode.create((BslOperator)operator.getOperator(), (BslExpression)operand, (ParseTree)operator.getActualSourceCode());
                this.operands.push(operation);
                break;
            }
            default: {
                BslExpression right = (BslExpression)this.operands.pop();
                BslExpression left = (BslExpression)this.operands.pop();
                BinaryOperationNode binaryOp = BinaryOperationNode.create((BslOperator)operator.getOperator(), (BslExpression)left, (BslExpression)right, (ParseTree)operator.getActualSourceCode());
                this.operands.push(binaryOp);
            }
        }
    }
}

