# Ограничение на размер метода (MethodSize)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |     Теги      |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:-------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                `30`                 | `badpractice` |

## Параметры


|       Имя       |   Тип   |               Описание                |    Значение<br>по умолчанию    |
|:---------------:|:-------:|:-------------------------------------:|:------------------------------:|
| `maxMethodSize` | `Целое` | `Максимальная длина метода в строках` |             `200`              |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Существуют громоздкие методы (процедуры и функции), с которыми невозможно эффективно работать именно из-за их огромного размера.  
Большой метод зачастую возникает, когда разработчик добавляет в метод новый функционал. "Зачем мне выносить проверку параметров в отдельный метод, если я могу написать ее тут?", "Для чего необходимо выделять метод поиска максимального элемента в массиве, оставим его тут. Так код яснее", - и прочие заблуждения.  

Есть два правила рефакторинга большого метода:

- Если при написании метода хочется добавить комментарий в код, необходимо выделить этот функционал в отдельный метод
- Если метод занимает более 50-100 строк кода, следует определить задачи и подзадачи, которые он выполняет, и попробовать вынести подзадачи в отдельный метод

## Источники

- [Рефакторинг архитектуры программного обеспечения: выделение слоев](http://citforum.ru/SE/project/refactor/)
- [Martin Fowler: Refactoring](https://www.refactoring.com/)
- [Инструменты рефакторинга и отказа от модальности](https://v8.1c.ru/o7/201312ref/index.htm)
- [Инструменты рефакторинга в 1С](https://www.koderline.ru/expert/programming/article-vspomogatelnye-funktsii-v-1s/#anchor6)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:MethodSize-off
// BSLLS:MethodSize-on
```

### Параметр конфигурационного файла

```json
"MethodSize": {
    "maxMethodSize": 200
}
```
