# Конструкция "Попытка...Исключение...КонецПопытки" не содержит кода в исключении (MissingCodeTryCatchEx)

|   Тип    |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |               Теги                |
|:--------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:---------------------------------:|
| `Ошибка` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                `15`                 |    `standard`<br>`badpractice`    |

## Параметры


|       Имя       |   Тип    |                 Описание                 |    Значение<br>по умолчанию    |
|:---------------:|:--------:|:----------------------------------------:|:------------------------------:|
| `commentAsCode` | `Булево` | `Считать комментарий в исключении кодом` |            `false`             |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Недопустимо перехватывать любые исключения, бесследно для системного администратора.

*Неправильно*

```bsl
Попытка 
    // код, приводящий к вызову исключения
    ....
Исключение // перехват любых исключений
КонецПопытки;

```

Как правило, подобная конструкция скрывает реальную проблему, которую впоследствии невозможно диагностировать. 

*Правильно*

```bsl
Попытка 
    // код, приводящий к вызову исключения
    ....
Исключение
    // Пояснение причин перехвата всех исключений "незаметно" от пользователя.
    // ....
    // И запись события в журнал регистрации для системного администратора.
    ЗаписьЖурналаРегистрации(НСтр("ru = 'Выполнение операции'"),
       УровеньЖурналаРегистрации.Ошибка,,,
       ПодробноеПредставлениеОшибки(ИнформацияОбОшибке()));
КонецПопытки;
```

## Источники

* [Перехват исключений в коде](https://its.1c.ru/db/v8std#content:499:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:MissingCodeTryCatchEx-off
// BSLLS:MissingCodeTryCatchEx-on
```

### Параметр конфигурационного файла

```json
"MissingCodeTryCatchEx": {
    "commentAsCode": false
}
```
