# Управляющие конструкции не должны быть вложены слишком глубоко (NestedStatements)

|      Тип      |    Поддерживаются<br>языки    |  Важность   |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                  Теги                  |
|:-------------:|:-----------------------------:|:-----------:|:------------------------------:|:-----------------------------------:|:--------------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Критичный` |              `Да`              |                `30`                 |    `badpractice`<br>`brainoverload`    |

## Параметры


|        Имя        |   Тип   |                    Описание                    |    Значение<br>по умолчанию    |
|:-----------------:|:-------:|:----------------------------------------------:|:------------------------------:|
| `maxAllowedLevel` | `Целое` | `Максимальный уровень вложенности конструкций` |              `4`               |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Вложенные операторы "Если, "Для", "Для Каждого", "Пока" и "Попытка" являются ключевыми ингредиентами для создания так называемого "спагетти-кода".

Такой код трудно читать, рефакторить и поддерживать.

## Примеры

Неправильно

```bsl

Если Чтото Тогда                  // Допустимо - уровень = 1
  /* ... */
  Если ЧтоТоЕще Тогда             // Допустимо - уровень = 2
    /* ... */
    Для Ном = 0 По 10 Цикл          // Допустимо - уровень = 3
      /* ... */
      Если ОпятьУсловие Тогда       // Допустимо - уровень = 4, лимит достигнут, но не превышен
        Если ЕщеЧтото Тогда        // Уровень = 5, Превышен лимит
          /* ... */
        КонецЕсли;
        Возврат;
      КонецЕсли;
    КонецЦикла;
  КонецЕсли;
КонецЕсли;

```

## Источники

* [RSPEC-134](https://rules.sonarsource.com/java/RSPEC-134)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:NestedStatements-off
// BSLLS:NestedStatements-on
```

### Параметр конфигурационного файла

```json
"NestedStatements": {
    "maxAllowedLevel": 4
}
```
