# Нестандартные разделы модуля (NonStandardRegion)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |    Теги    |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:----------:|
| `Дефект кода` |             `BSL`             | `Информационный` |              `Да`              |                 `1`                 | `standard` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Весь код модуля должен быть структурирован и разделен по разделам (областям).  
Набор разделов для каждого типа модуля (модуль формы, модуль объект, общий модуль и т.д.) однозначно определен, наличие посторонних разделов недопустимо.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->


* Источник [Соглашения при написания кода. Структура модуля](https://its.1c.ru/db/v8std#content:455:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:NonStandardRegion-off
// BSLLS:NonStandardRegion-on
```

### Параметр конфигурационного файла

```json
"NonStandardRegion": false
```
