# Ошибка разбора исходного кода (ParseError)

|   Тип    |    Поддерживаются<br>языки    |  Важность   |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |  Теги   |
|:--------:|:-----------------------------:|:-----------:|:------------------------------:|:-----------------------------------:|:-------:|
| `Ошибка` |         `BSL`<br>`OS`         | `Критичный` |              `Да`              |                 `5`                 | `error` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Ошибка возникает если исходный код модуля написан с нарушением синтаксиса языка или при неправильном использовании инструкций препроцессора.

Не следует разрывать инструкциями препроцессора и областями отдельные грамматические конструкции, выражения, а также объявления и места вызова процедур и функций.

## Примеры

Неправильно:

```bsl
Процедура Пример1()
  а = 1
#Область ИмяОбласти
    + 2;
#КонецОбласти // разрыв выражения
КонецПроцедуры

#Область ИмяОбласти
Процедура Пример2()
    // ...
#КонецОбласти // разрыв процедуры
КонецПроцедуры

Если <...> Тогда
    // ...
#Если ВебКлиент Тогда // разрыв блока Если
Иначе
    // ...
#КонецЕсли
КонецЕсли;

Результат = Пример4(Параметр1, 
#Если Клиент Тогда
  Параметр2, // некорректный вызов функции
#КонецЕсли
  Параметр3);
```

## Источники

* [Стандарт: #439 Использование директив компиляции и инструкций препроцессора](https://its.1c.ru/db/v8std#content:439:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:ParseError-off
// BSLLS:ParseError-on
```

### Параметр конфигурационного файла

```json
"ParseError": false
```
