# Неиспользуемая локальная переменная (UnusedLocalVariable)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                           Теги                           |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:--------------------------------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                 `1`                 |       `brainoverload`<br>`badpractice`<br>`unused`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
Программные модули не должны иметь неиспользуемых переменных.

Если локальная переменная объявлена, но не используется, это мертвый код, который следует удалить.
Это улучшит удобство обслуживания, поскольку разработчики не будут удивляться, для чего используется переменная.

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:UnusedLocalVariable-off
// BSLLS:UnusedLocalVariable-on
```

### Параметр конфигурационного файла

```json
"UnusedLocalVariable": false
```
