/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver;

import com.github._1c_syntax.bsl.languageserver.aop.SentryAspect;
import com.github._1c_syntax.bsl.languageserver.commands.CommandArguments;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.providers.CommandProvider;
import com.github._1c_syntax.bsl.languageserver.providers.SymbolProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component
public class BSLWorkspaceService
implements WorkspaceService {
    private final LanguageServerConfiguration configuration;
    private final CommandProvider commandProvider;
    private final SymbolProvider symbolProvider;
    private final ExecutorService executorService = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("workspace-service-"));

    @PreDestroy
    private void onDestroy() {
        this.executorService.shutdown();
    }

    public CompletableFuture<Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>>> symbol(WorkspaceSymbolParams params) {
        try {
            return CompletableFuture.supplyAsync(() -> Either.forRight(this.symbolProvider.getSymbols(params)), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        try {
            try {
                PropertyUtils.copyProperties((Object)this.configuration, (Object)params.getSettings());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        try {
            return;
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        try {
            CommandArguments arguments = this.commandProvider.extractArguments(params);
            return CompletableFuture.supplyAsync(() -> this.commandProvider.executeCommand(arguments), this.executorService);
        }
        catch (Throwable throwable) {
            SentryAspect.aspectOf().logThrowingLSPCall(throwable);
            throw throwable;
        }
    }

    @ConstructorProperties(value={"configuration", "commandProvider", "symbolProvider"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BSLWorkspaceService(LanguageServerConfiguration configuration, CommandProvider commandProvider, SymbolProvider symbolProvider) {
        this.configuration = configuration;
        this.commandProvider = commandProvider;
        this.symbolProvider = symbolProvider;
    }
}

