/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.aop;

import com.github._1c_syntax.bsl.languageserver.aop.measures.MeasureCollector;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.ServerContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.BSLDiagnostic;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.util.Collection;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class MeasuresAspect {
    private MeasureCollector measureCollector;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ MeasuresAspect ajc$perSingletonInstance;

    @PreDestroy
    void destroy() {
        this.setMeasureCollector(null);
    }

    @Around(value="Pointcuts.isBSLDiagnostic() && Pointcuts.isGetDiagnosticsCall()")
    public Object measureBSLDiagnostic(ProceedingJoinPoint jp) throws Throwable {
        if (this.measureCollector == null) {
            return jp.proceed();
        }
        BSLDiagnostic diagnostic = (BSLDiagnostic)jp.getThis();
        String diagnosticCode = diagnostic.getInfo().getCode().getStringValue();
        return this.measureCollector.measureIt(() -> ((ProceedingJoinPoint)jp).proceed(), "diagnostic: " + diagnosticCode);
    }

    @Before(value="Pointcuts.isDocumentContext() && execution(* computeSymbolTree(..))")
    public void measureGetTokens(JoinPoint jp) {
        if (this.measureCollector == null) {
            return;
        }
        DocumentContext documentContext = (DocumentContext)jp.getTarget();
        this.measureCollector.measureIt(documentContext::getTokens, "context: tokens");
        this.measureCollector.measureIt(documentContext::getAst, "context: ast");
    }

    @Around(value="Pointcuts.isDocumentContext() && execution(* computeSymbolTree(..))")
    public Object measureComputeSymbolTree(ProceedingJoinPoint jp) throws Throwable {
        if (this.measureCollector == null) {
            return jp.proceed();
        }
        return this.measureCollector.measureIt(() -> ((ProceedingJoinPoint)jp).proceed(), "context: symbolTree");
    }

    @Before(value="Pointcuts.isServerContext() && execution(* populateContext(..)) && args(files)")
    public void initializeConfiguration(JoinPoint jp, Collection<File> files) {
        if (this.measureCollector == null) {
            return;
        }
        ServerContext serverContext = (ServerContext)jp.getTarget();
        this.measureCollector.measureIt(serverContext::getConfiguration, "context: configuration");
    }

    @Around(value="within(com.github._1c_syntax.bsl.languageserver.context.computer.*) && execution(* compute(..))")
    public Object measureComputers(ProceedingJoinPoint jp) throws Throwable {
        if (this.measureCollector == null) {
            return jp.proceed();
        }
        String simpleName = jp.getTarget().getClass().getSimpleName();
        return this.measureCollector.measureIt(() -> ((ProceedingJoinPoint)jp).proceed(), "computer: " + simpleName);
    }

    @AfterReturning(value="within(com.github._1c_syntax.bsl.languageserver.cli.AnalyzeCommand) && execution(* call(..))")
    public void printMeasures() {
        if (this.measureCollector == null) {
            return;
        }
        this.measureCollector.printMeasures();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MeasuresAspect() {
    }

    @Autowired
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMeasureCollector(MeasureCollector measureCollector) {
        this.measureCollector = measureCollector;
    }

    public static MeasuresAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.github._1c_syntax.bsl.languageserver.aop.MeasuresAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            MeasuresAspect.ajc$perSingletonInstance = new MeasuresAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

