/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.aop;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.sentry.Sentry;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

@Aspect
public class SentryAspect {
    private ExecutorService executorService;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ SentryAspect ajc$perSingletonInstance;

    @PostConstruct
    private void init() {
        this.executorService = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("sentry-"));
    }

    @PreDestroy
    private void onDestroy() {
        this.executorService.shutdown();
    }

    @AfterThrowing(value="Pointcuts.isBSLDiagnostic() && Pointcuts.isGetDiagnosticsCall()", throwing="ex")
    public void logThrowingBSLDiagnosticGetDiagnostics(Throwable ex) {
        CompletableFuture.runAsync(() -> Sentry.captureException((Throwable)ex), this.executorService);
    }

    @AfterThrowing(value="Pointcuts.isPublicMethodCall() && (Pointcuts.isLanguageServer() || Pointcuts.isTextDocumentService() || Pointcuts.isWorkspaceService())", throwing="ex")
    public void logThrowingLSPCall(Throwable ex) {
        CompletableFuture.runAsync(() -> Sentry.captureException((Throwable)ex), this.executorService);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SentryAspect() {
    }

    public static SentryAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.github._1c_syntax.bsl.languageserver.aop.SentryAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            SentryAspect.ajc$perSingletonInstance = new SentryAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

