/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.cfg;

import com.github._1c_syntax.bsl.languageserver.cfg.BranchingVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.CfgEdge;
import com.github._1c_syntax.bsl.languageserver.cfg.CfgEdgeType;
import com.github._1c_syntax.bsl.languageserver.cfg.CfgVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.ControlFlowGraph;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public class ControlFlowGraphWalker {
    private final ControlFlowGraph graph;
    private CfgVertex currentNode;

    public void start() {
        this.currentNode = this.graph.getEntryPoint();
    }

    public Set<CfgEdge> availableRoutes() {
        return this.graph.outgoingEdgesOf(this.currentNode);
    }

    public CfgEdge walkNext() {
        Set<CfgEdge> edges = this.availableRoutes();
        Optional<CfgEdge> edgeOrNot = edges.stream().filter(x -> x.getType() == CfgEdgeType.DIRECT).findFirst();
        if (edgeOrNot.isPresent()) {
            this.currentNode = (CfgVertex)this.graph.getEdgeTarget((Object)edgeOrNot.get());
            return edgeOrNot.get();
        }
        throw new IllegalStateException("DIRECT edge is not found for node " + this.currentNode);
    }

    public CfgEdge walkNext(CfgEdgeType edgeType) {
        Optional<CfgEdge> edgeOrNot = this.availableRoutes().stream().filter(x -> x.getType() == edgeType).findAny();
        if (edgeOrNot.isPresent()) {
            this.currentNode = (CfgVertex)this.graph.getEdgeTarget((Object)edgeOrNot.get());
            return edgeOrNot.get();
        }
        throw new IllegalStateException("Edge is not found for node " + this.currentNode);
    }

    public void walkTo(CfgVertex target) {
        this.currentNode = target;
    }

    public boolean isOnBranch() {
        return this.currentNode instanceof BranchingVertex;
    }

    @ConstructorProperties(value={"graph"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ControlFlowGraphWalker(ControlFlowGraph graph) {
        this.graph = graph;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CfgVertex getCurrentNode() {
        return this.currentNode;
    }
}

