/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.cli;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.springframework.stereotype.Component;
import picocli.CommandLine;

@CommandLine.Command(name="websocket", aliases={"-w", "--websocket"}, description={"Websocket server mode"}, usageHelpAutoWidth=true, footer={"@|green Copyright(c) 2018-2022|@"})
@Component
public class WebsocketCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message and exit"})
    private boolean usageHelpRequested;
    @CommandLine.Option(names={"-c", "--configuration"}, description={"Path to language server configuration file"}, paramLabel="<path>", defaultValue="")
    private String configurationOption;
    @CommandLine.Option(names={"--server.port"}, description={"Port to listen. Default is 8025"}, paramLabel="<port>", defaultValue="8025")
    private int serverPort;
    @CommandLine.Option(names={"--app.websocket.lsp-path"}, description={"Path to LSP endpoint. Default is /lsp"}, paramLabel="<path>", defaultValue="/lsp")
    private String endpointPath;
    private final LanguageServerConfiguration configuration;

    @Override
    public Integer call() {
        File configurationFile = new File(this.configurationOption);
        if (configurationFile.exists()) {
            this.configuration.update(configurationFile);
        }
        return -1;
    }

    @ConstructorProperties(value={"configuration"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public WebsocketCommand(LanguageServerConfiguration configuration) {
        this.configuration = configuration;
    }
}

