/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.codelenses.testrunner;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.configuration.codelens.TestRunnerAdapterOptions;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TestRunnerAdapter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TestRunnerAdapter.class);
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("\r?\n");
    private static final Map<Pair<DocumentContext, Integer>, List<String>> CACHE = new WeakHashMap<Pair<DocumentContext, Integer>, List<String>>();
    private final LanguageServerConfiguration configuration;

    public List<String> getTestIds(DocumentContext documentContext) {
        Pair cacheKey = Pair.of((Object)documentContext, (Object)documentContext.getVersion());
        return CACHE.computeIfAbsent((Pair<DocumentContext, Integer>)cacheKey, pair -> this.computeTestIds(documentContext));
    }

    private List<String> computeTestIds(DocumentContext documentContext) {
        TestRunnerAdapterOptions options = this.configuration.getCodeLensOptions().getTestRunnerAdapterOptions();
        String executable = SystemUtils.IS_OS_WINDOWS ? options.getExecutableWin() : options.getExecutable();
        String path = Paths.get(documentContext.getUri()).toString();
        String arguments = String.format(options.getGetTestsArguments(), path);
        CommandLine getTestsCommand = new CommandLine(executable).addArguments(arguments, false);
        long timeout = 10000L;
        ExecuteWatchdog watchdog = ExecuteWatchdog.builder().setTimeout(Duration.ofMillis(timeout)).get();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)outputStream);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        DefaultExecutor executor = DefaultExecutor.builder().get();
        executor.setWatchdog(watchdog);
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        try {
            executor.execute(getTestsCommand, (ExecuteResultHandler)resultHandler);
        }
        catch (IOException e) {
            LOGGER.error("Can't execute testrunner getTests command", (Throwable)e);
            return Collections.emptyList();
        }
        try {
            resultHandler.waitFor();
        }
        catch (InterruptedException e) {
            LOGGER.error("Can't wait for testrunner getTests command", (Throwable)e);
            Thread.currentThread().interrupt();
            return Collections.emptyList();
        }
        Pattern getTestsRegex = Pattern.compile(options.getGetTestsResultPattern());
        Charset charset = SystemUtils.IS_OS_WINDOWS ? Charset.forName("cp866") : Charset.defaultCharset();
        String output = outputStream.toString(charset);
        return Arrays.stream(NEW_LINE_PATTERN.split(output)).map(getTestsRegex::matcher).filter(Matcher::matches).map(matcher -> matcher.group(1)).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"configuration"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TestRunnerAdapter(LanguageServerConfiguration configuration) {
        this.configuration = configuration;
    }
}

