/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context;

import com.github._1c_syntax.bsl.languageserver.aop.EventPublisherAspect;
import com.github._1c_syntax.bsl.languageserver.aop.MeasuresAspect;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext$AjcClosure1;
import com.github._1c_syntax.bsl.languageserver.context.FileType;
import com.github._1c_syntax.bsl.languageserver.context.MetricStorage;
import com.github._1c_syntax.bsl.languageserver.context.ServerContext;
import com.github._1c_syntax.bsl.languageserver.context.computer.CognitiveComplexityComputer;
import com.github._1c_syntax.bsl.languageserver.context.computer.ComplexityData;
import com.github._1c_syntax.bsl.languageserver.context.computer.Computer;
import com.github._1c_syntax.bsl.languageserver.context.computer.CyclomaticComplexityComputer;
import com.github._1c_syntax.bsl.languageserver.context.computer.DiagnosticComputer;
import com.github._1c_syntax.bsl.languageserver.context.computer.DiagnosticIgnoranceComputer;
import com.github._1c_syntax.bsl.languageserver.context.computer.QueryComputer;
import com.github._1c_syntax.bsl.languageserver.context.computer.SymbolTreeComputer;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SymbolTree;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.mdclasses.CF;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.mdo.support.ScriptVariant;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLTokenizer;
import com.github._1c_syntax.bsl.parser.SDBLTokenizer;
import com.github._1c_syntax.bsl.support.SupportVariant;
import com.github._1c_syntax.bsl.types.ConfigurationSource;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.github._1c_syntax.utils.Lazy;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DocumentContext {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER;
    private static final Pattern CONTENT_SPLIT_PATTERN;
    private final URI uri;
    @Nullable
    private String content;
    private int version;
    private ServerContext context;
    private DiagnosticComputer diagnosticComputer;
    private LanguageServerConfiguration configuration;
    private ObjectProvider<CognitiveComplexityComputer> cognitiveComplexityComputerProvider;
    private ObjectProvider<CyclomaticComplexityComputer> cyclomaticComplexityComputerProvider;
    private FileType fileType;
    private BSLTokenizer tokenizer;
    private SymbolTree symbolTree;
    private boolean isComputedDataFrozen;
    private final ReentrantLock computeLock = new ReentrantLock();
    private final ReentrantLock diagnosticsLock = new ReentrantLock();
    private final Lazy<String[]> contentList = new Lazy(this::computeContentList, this.computeLock);
    private final Lazy<ModuleType> moduleType = new Lazy(this::computeModuleType, this.computeLock);
    private final Lazy<ComplexityData> cognitiveComplexityData = new Lazy(this::computeCognitiveComplexity, this.computeLock);
    private final Lazy<ComplexityData> cyclomaticComplexityData = new Lazy(this::computeCyclomaticComplexity, this.computeLock);
    private final Lazy<DiagnosticIgnoranceComputer.Data> diagnosticIgnoranceData = new Lazy(this::computeDiagnosticIgnorance, this.computeLock);
    private final Lazy<MetricStorage> metrics = new Lazy(this::computeMetrics, this.computeLock);
    private final Lazy<List<Diagnostic>> diagnostics = new Lazy(this::computeDiagnostics, this.diagnosticsLock);
    private final Lazy<List<SDBLTokenizer>> queries = new Lazy(this::computeQueries, this.computeLock);
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    @PostConstruct
    void init() {
        this.fileType = DocumentContext.computeFileType(this.uri);
    }

    public ServerContext getServerContext() {
        return this.context;
    }

    public String getContent() {
        Objects.requireNonNull(this.content);
        return this.content;
    }

    public String[] getContentList() {
        return (String[])this.contentList.getOrCompute();
    }

    public BSLParser.FileContext getAst() {
        Objects.requireNonNull(this.content);
        return (BSLParser.FileContext)this.tokenizer.getAst();
    }

    public List<Token> getTokens() {
        Objects.requireNonNull(this.content);
        return this.tokenizer.getTokens();
    }

    public List<Token> getTokensFromDefaultChannel() {
        return this.getTokens().stream().filter(token -> token.getChannel() == 0).collect(Collectors.toList());
    }

    public List<Token> getComments() {
        return this.getTokens().stream().filter(token -> token.getType() == 1).collect(Collectors.toList());
    }

    public String getText(Range range) {
        Position start = range.getStart();
        Position end = range.getEnd();
        String[] contentListUnboxed = this.getContentList();
        if (start.getLine() > contentListUnboxed.length || end.getLine() > contentListUnboxed.length) {
            throw new ArrayIndexOutOfBoundsException("Range goes beyond the boundaries of the parsed document");
        }
        String startString = contentListUnboxed[start.getLine()];
        StringBuilder sb = new StringBuilder();
        if (start.getLine() == end.getLine()) {
            sb.append(startString, start.getCharacter(), end.getCharacter());
        } else {
            sb.append(startString.substring(start.getCharacter())).append("\n");
        }
        for (int i = start.getLine() + 1; i <= end.getLine() - 1; ++i) {
            sb.append(contentListUnboxed[i]).append("\n");
        }
        if (start.getLine() != end.getLine()) {
            sb.append(contentListUnboxed[end.getLine()], 0, end.getCharacter());
        }
        return sb.toString();
    }

    public Locale getScriptVariantLocale() {
        String languageTag;
        CF mdConfiguration = this.getServerContext().getConfiguration();
        if (mdConfiguration.getConfigurationSource() == ConfigurationSource.EMPTY || this.fileType == FileType.OS) {
            languageTag = this.configuration.getLanguage().getLanguageCode();
        } else {
            ScriptVariant scriptVariant = mdConfiguration.getScriptVariant();
            if (scriptVariant == ScriptVariant.ENGLISH) {
                languageTag = "en";
            } else if (scriptVariant == ScriptVariant.RUSSIAN) {
                languageTag = "ru";
            } else {
                throw new IllegalArgumentException("Unknown scriptVariant " + scriptVariant);
            }
        }
        return Locale.forLanguageTag(languageTag);
    }

    public MetricStorage getMetrics() {
        return (MetricStorage)this.metrics.getOrCompute();
    }

    public ComplexityData getCognitiveComplexityData() {
        return (ComplexityData)this.cognitiveComplexityData.getOrCompute();
    }

    public ComplexityData getCyclomaticComplexityData() {
        return (ComplexityData)this.cyclomaticComplexityData.getOrCompute();
    }

    public DiagnosticIgnoranceComputer.Data getDiagnosticIgnorance() {
        return (DiagnosticIgnoranceComputer.Data)this.diagnosticIgnoranceData.getOrCompute();
    }

    public ModuleType getModuleType() {
        return (ModuleType)this.moduleType.getOrCompute();
    }

    public SupportVariant getSupportVariant() {
        return this.getMdObject().map(MD::getSupportVariant).orElse(SupportVariant.NONE);
    }

    public Optional<MD> getMdObject() {
        return this.getServerContext().getConfiguration().findChild(this.getUri());
    }

    public List<SDBLTokenizer> getQueries() {
        return (List)this.queries.getOrCompute();
    }

    public List<Diagnostic> getDiagnostics() {
        return (List)this.diagnostics.getOrCompute();
    }

    public List<Diagnostic> getComputedDiagnostics() {
        return Optional.ofNullable((List)this.diagnostics.get()).orElseGet(Collections::emptyList);
    }

    public void freezeComputedData() {
        this.isComputedDataFrozen = true;
    }

    public void unfreezeComputedData() {
        this.isComputedDataFrozen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuild(String content, int version) {
        String string = content;
        int n = version;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n));
        this.computeLock.lock();
        try {
            boolean versionMatches;
            boolean bl = versionMatches = version == this.version && version != 0;
            if (versionMatches && this.content != null) {
                this.clearDependantData();
                this.computeLock.unlock();
            } else {
                if (!this.isComputedDataFrozen) {
                    this.clearSecondaryData();
                }
                this.content = content;
                this.tokenizer = new BSLTokenizer(content);
                this.version = version;
                this.symbolTree = this.computeSymbolTree();
            }
        }
        finally {
            this.computeLock.unlock();
        }
        EventPublisherAspect.aspectOf().documentContextRebuild(joinPoint);
    }

    protected void rebuild() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            String newContent = FileUtils.readFileToString((File)new File(this.uri), (Charset)StandardCharsets.UTF_8);
            this.rebuild(newContent, 0);
        }
        catch (IOException e) {
            LOGGER.error("Can't rebuild content from uri", (Throwable)e);
        }
        EventPublisherAspect.aspectOf().documentContextRebuild(joinPoint);
    }

    protected void clearSecondaryData() {
        this.computeLock.lock();
        try {
            this.content = null;
            this.contentList.clear();
            this.tokenizer = null;
            this.queries.clear();
            this.clearDependantData();
            if (!this.isComputedDataFrozen) {
                this.cognitiveComplexityData.clear();
                this.cyclomaticComplexityData.clear();
                this.metrics.clear();
                this.diagnosticIgnoranceData.clear();
            }
        }
        finally {
            this.computeLock.unlock();
        }
    }

    private void clearDependantData() {
        this.computeLock.lock();
        this.diagnosticsLock.lock();
        try {
            this.diagnostics.clear();
        }
        finally {
            this.diagnosticsLock.unlock();
            this.computeLock.unlock();
        }
    }

    private static FileType computeFileType(URI uri) {
        FileType fileTypeFromUri;
        String uriPath = uri.getPath();
        if (uriPath == null) {
            return FileType.BSL;
        }
        try {
            fileTypeFromUri = FileType.valueOf(FilenameUtils.getExtension((String)uriPath).toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException ignored) {
            fileTypeFromUri = FileType.BSL;
        }
        return fileTypeFromUri;
    }

    private String[] computeContentList() {
        return CONTENT_SPLIT_PATTERN.split(this.getContent(), -1);
    }

    private SymbolTree computeSymbolTree() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        MeasuresAspect.aspectOf().measureGetTokens(joinPoint);
        Object[] objectArray = new Object[]{this, joinPoint};
        DocumentContext$AjcClosure1 documentContext$AjcClosure1 = new DocumentContext$AjcClosure1(objectArray);
        return (SymbolTree)MeasuresAspect.aspectOf().measureComputeSymbolTree(documentContext$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private ModuleType computeModuleType() {
        return this.context.getConfiguration().getModuleTypeByURI(this.uri);
    }

    private ComplexityData computeCognitiveComplexity() {
        Computer cognitiveComplexityComputer = (Computer)this.cognitiveComplexityComputerProvider.getObject(new Object[]{this});
        return (ComplexityData)cognitiveComplexityComputer.compute();
    }

    private ComplexityData computeCyclomaticComplexity() {
        Computer cyclomaticComplexityComputer = (Computer)this.cyclomaticComplexityComputerProvider.getObject(new Object[]{this});
        return (ComplexityData)cyclomaticComplexityComputer.compute();
    }

    private MetricStorage computeMetrics() {
        MetricStorage metricsTemp = new MetricStorage();
        List<MethodSymbol> methodsUnboxed = this.symbolTree.getMethods();
        metricsTemp.setFunctions(Math.toIntExact(methodsUnboxed.stream().filter(MethodSymbol::isFunction).count()));
        metricsTemp.setProcedures(methodsUnboxed.size() - metricsTemp.getFunctions());
        int[] nclocData = this.getTokensFromDefaultChannel().stream().mapToInt(Token::getLine).distinct().toArray();
        metricsTemp.setNclocData(nclocData);
        metricsTemp.setNcloc(nclocData.length);
        List<Token> tokensUnboxed = this.getTokens();
        int lines = tokensUnboxed.isEmpty() ? 0 : tokensUnboxed.get(tokensUnboxed.size() - 1).getLine();
        metricsTemp.setLines(lines);
        int comments = (int)this.getComments().stream().map(Token::getLine).distinct().count();
        metricsTemp.setComments(comments);
        int statements = Trees.findAllRuleNodes((ParseTree)this.getAst(), 80).size();
        metricsTemp.setStatements(statements);
        metricsTemp.setCognitiveComplexity(this.getCognitiveComplexityData().getFileComplexity());
        metricsTemp.setCyclomaticComplexity(this.getCyclomaticComplexityData().getFileComplexity());
        return metricsTemp;
    }

    private DiagnosticIgnoranceComputer.Data computeDiagnosticIgnorance() {
        DiagnosticIgnoranceComputer diagnosticIgnoranceComputer = new DiagnosticIgnoranceComputer(this);
        return (DiagnosticIgnoranceComputer.Data)diagnosticIgnoranceComputer.compute();
    }

    private List<Diagnostic> computeDiagnostics() {
        return this.diagnosticComputer.compute(this);
    }

    private List<SDBLTokenizer> computeQueries() {
        return new QueryComputer(this).compute();
    }

    @ConstructorProperties(value={"uri"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocumentContext(URI uri) {
        this.uri = uri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public URI getUri() {
        return this.uri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getVersion() {
        return this.version;
    }

    @Autowired
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setContext(ServerContext context) {
        this.context = context;
    }

    @Autowired
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDiagnosticComputer(DiagnosticComputer diagnosticComputer) {
        this.diagnosticComputer = diagnosticComputer;
    }

    @Autowired
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConfiguration(LanguageServerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Autowired
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCognitiveComplexityComputerProvider(ObjectProvider<CognitiveComplexityComputer> cognitiveComplexityComputerProvider) {
        this.cognitiveComplexityComputerProvider = cognitiveComplexityComputerProvider;
    }

    @Autowired
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCyclomaticComplexityComputerProvider(ObjectProvider<CyclomaticComplexityComputer> cyclomaticComplexityComputerProvider) {
        this.cyclomaticComplexityComputerProvider = cyclomaticComplexityComputerProvider;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public FileType getFileType() {
        return this.fileType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BSLTokenizer getTokenizer() {
        return this.tokenizer;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SymbolTree getSymbolTree() {
        return this.symbolTree;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isComputedDataFrozen() {
        return this.isComputedDataFrozen;
    }

    static {
        DocumentContext.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(DocumentContext.class);
        CONTENT_SPLIT_PATTERN = Pattern.compile("\r?\n|\r");
    }

    static final /* synthetic */ SymbolTree computeSymbolTree_aroundBody0(DocumentContext ajc$this, JoinPoint joinPoint) {
        return new SymbolTreeComputer(ajc$this).compute();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DocumentContext.java", DocumentContext.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "rebuild", "com.github._1c_syntax.bsl.languageserver.context.DocumentContext", "java.lang.String:int", "content:version", "", "void"), 270);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "rebuild", "com.github._1c_syntax.bsl.languageserver.context.DocumentContext", "", "", "", "void"), 299);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "computeSymbolTree", "com.github._1c_syntax.bsl.languageserver.context.DocumentContext", "", "", "", "com.github._1c_syntax.bsl.languageserver.context.symbol.SymbolTree"), 363);
    }
}

