/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context.computer;

import com.github._1c_syntax.bsl.languageserver.aop.MeasuresAspect;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.computer.CognitiveComplexityComputer$AjcClosure1;
import com.github._1c_syntax.bsl.languageserver.context.computer.ComplexityData;
import com.github._1c_syntax.bsl.languageserver.context.computer.ComplexitySecondaryLocation;
import com.github._1c_syntax.bsl.languageserver.context.computer.Computer;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserBaseListener;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.StringInterner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.Tree;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class CognitiveComplexityComputer
extends BSLParserBaseListener
implements Computer<ComplexityData> {
    private final DocumentContext documentContext;
    private StringInterner stringInterner;
    private int fileComplexity;
    private int fileCodeBlockComplexity;
    private List<ComplexitySecondaryLocation> fileBlockComplexitySecondaryLocations;
    private Map<MethodSymbol, Integer> methodsComplexity;
    private Map<MethodSymbol, List<ComplexitySecondaryLocation>> methodsComplexitySecondaryLocations;
    private MethodSymbol currentMethod;
    private int complexity;
    private int nestedLevel;
    private Set<BSLParserRuleContext> ignoredContexts;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        this.fileComplexity = 0;
        this.fileCodeBlockComplexity = 0;
        this.fileBlockComplexitySecondaryLocations = new ArrayList<ComplexitySecondaryLocation>();
        this.resetMethodComplexityCounters();
        this.methodsComplexity = new HashMap<MethodSymbol, Integer>();
        this.methodsComplexitySecondaryLocations = new HashMap<MethodSymbol, List<ComplexitySecondaryLocation>>();
        this.ignoredContexts = new HashSet<BSLParserRuleContext>();
    }

    @Override
    public ComplexityData compute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        CognitiveComplexityComputer$AjcClosure1 cognitiveComplexityComputer$AjcClosure1 = new CognitiveComplexityComputer$AjcClosure1(objectArray);
        return (ComplexityData)MeasuresAspect.aspectOf().measureComputers(cognitiveComplexityComputer$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void enterSub(BSLParser.SubContext ctx) {
        Optional<MethodSymbol> methodSymbol = this.documentContext.getSymbolTree().getMethodSymbol((BSLParserRuleContext)ctx);
        if (methodSymbol.isEmpty()) {
            return;
        }
        this.resetMethodComplexityCounters();
        this.currentMethod = methodSymbol.get();
        super.enterSub(ctx);
    }

    public void exitSub(BSLParser.SubContext ctx) {
        this.incrementFileComplexity();
        if (this.currentMethod != null) {
            this.methodsComplexity.put(this.currentMethod, this.complexity);
        }
        this.currentMethod = null;
        this.ignoredContexts.clear();
        super.exitSub(ctx);
    }

    public void enterFileCodeBlockBeforeSub(BSLParser.FileCodeBlockBeforeSubContext ctx) {
        this.resetMethodComplexityCounters();
        super.enterFileCodeBlockBeforeSub(ctx);
    }

    public void exitFileCodeBlockBeforeSub(BSLParser.FileCodeBlockBeforeSubContext ctx) {
        this.incrementFileComplexity();
        this.incrementFileCodeBlockComplexity();
        this.ignoredContexts.clear();
        super.exitFileCodeBlockBeforeSub(ctx);
    }

    public void enterFileCodeBlock(BSLParser.FileCodeBlockContext ctx) {
        this.resetMethodComplexityCounters();
        super.enterFileCodeBlock(ctx);
    }

    public void exitFileCodeBlock(BSLParser.FileCodeBlockContext ctx) {
        this.incrementFileComplexity();
        this.incrementFileCodeBlockComplexity();
        this.ignoredContexts.clear();
        super.exitFileCodeBlock(ctx);
    }

    public void enterIfBranch(BSLParser.IfBranchContext ctx) {
        this.structuralIncrement(ctx.IF_KEYWORD().getSymbol());
        super.enterIfBranch(ctx);
    }

    public void exitIfBranch(BSLParser.IfBranchContext ctx) {
        --this.nestedLevel;
        super.exitIfBranch(ctx);
    }

    public void enterElsifBranch(BSLParser.ElsifBranchContext ctx) {
        this.hybridIncrement(ctx.ELSIF_KEYWORD().getSymbol());
        super.enterElsifBranch(ctx);
    }

    public void exitElsifBranch(BSLParser.ElsifBranchContext ctx) {
        --this.nestedLevel;
        super.exitElsifBranch(ctx);
    }

    public void enterElseBranch(BSLParser.ElseBranchContext ctx) {
        this.hybridIncrement(ctx.ELSE_KEYWORD().getSymbol());
        super.enterElseBranch(ctx);
    }

    public void exitElseBranch(BSLParser.ElseBranchContext ctx) {
        --this.nestedLevel;
        super.exitElseBranch(ctx);
    }

    public void enterTernaryOperator(BSLParser.TernaryOperatorContext ctx) {
        this.structuralIncrement(ctx.QUESTION().getSymbol());
        super.enterTernaryOperator(ctx);
    }

    public void exitTernaryOperator(BSLParser.TernaryOperatorContext ctx) {
        --this.nestedLevel;
        super.exitTernaryOperator(ctx);
    }

    public void enterForEachStatement(BSLParser.ForEachStatementContext ctx) {
        this.structuralIncrement(ctx.FOR_KEYWORD().getSymbol());
        super.enterForEachStatement(ctx);
    }

    public void exitForEachStatement(BSLParser.ForEachStatementContext ctx) {
        --this.nestedLevel;
        super.exitForEachStatement(ctx);
    }

    public void enterForStatement(BSLParser.ForStatementContext ctx) {
        this.structuralIncrement(ctx.FOR_KEYWORD().getSymbol());
        super.enterForStatement(ctx);
    }

    public void exitForStatement(BSLParser.ForStatementContext ctx) {
        --this.nestedLevel;
        super.exitForStatement(ctx);
    }

    public void enterWhileStatement(BSLParser.WhileStatementContext ctx) {
        this.structuralIncrement(ctx.WHILE_KEYWORD().getSymbol());
        super.enterWhileStatement(ctx);
    }

    public void exitWhileStatement(BSLParser.WhileStatementContext ctx) {
        --this.nestedLevel;
        super.exitWhileStatement(ctx);
    }

    public void enterExceptCodeBlock(BSLParser.ExceptCodeBlockContext ctx) {
        this.structuralIncrement(((BSLParser.TryStatementContext)ctx.getParent()).EXCEPT_KEYWORD().getSymbol());
        super.enterExceptCodeBlock(ctx);
    }

    public void exitExceptCodeBlock(BSLParser.ExceptCodeBlockContext ctx) {
        --this.nestedLevel;
        super.exitExceptCodeBlock(ctx);
    }

    public void enterGotoStatement(BSLParser.GotoStatementContext ctx) {
        this.fundamentalIncrement(ctx.GOTO_KEYWORD().getSymbol());
        super.enterGotoStatement(ctx);
    }

    public void enterGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        BSLParser.MethodNameContext methodNameContext = ctx.methodName();
        if (methodNameContext != null && this.currentMethod != null) {
            String calledMethodName = methodNameContext.getText();
            if (this.currentMethod.getName().equalsIgnoreCase(calledMethodName)) {
                this.fundamentalIncrement(methodNameContext.IDENTIFIER().getSymbol());
            }
        }
        super.enterGlobalMethodCall(ctx);
    }

    public void enterExpression(BSLParser.ExpressionContext ctx) {
        if (this.ignoredContexts.contains(ctx)) {
            return;
        }
        List<Token> flattenExpression = this.flattenExpression(ctx);
        int emptyTokenType = -1;
        AtomicInteger lastOperationType = new AtomicInteger(emptyTokenType);
        flattenExpression.forEach(token -> {
            int currentOperationType = token.getType();
            if (lastOperationType.get() != currentOperationType) {
                lastOperationType.set(currentOperationType);
                if (currentOperationType != emptyTokenType) {
                    this.fundamentalIncrement((Token)token);
                }
            }
        });
        super.enterExpression(ctx);
    }

    private List<Token> flattenExpression(BSLParser.ExpressionContext ctx) {
        this.ignoredContexts.add((BSLParserRuleContext)ctx);
        ArrayList<Token> result = new ArrayList<Token>();
        List<Tree> children = Trees.getChildren((Tree)ctx);
        for (Tree tree : children) {
            if (!(tree instanceof BSLParserRuleContext)) continue;
            BSLParserRuleContext parserRule = (BSLParserRuleContext)tree;
            if (parserRule instanceof BSLParser.MemberContext) {
                BSLParser.MemberContext memberContext = (BSLParser.MemberContext)parserRule;
                this.flattenMember(result, memberContext);
                continue;
            }
            if (!(parserRule instanceof BSLParser.OperationContext)) continue;
            BSLParser.OperationContext operationContext = (BSLParser.OperationContext)parserRule;
            CognitiveComplexityComputer.flattenOperation(result, operationContext);
        }
        return result;
    }

    private void flattenMember(List<Token> result, BSLParser.MemberContext member) {
        BSLParser.ExpressionContext expression = member.expression();
        if (expression == null) {
            return;
        }
        List<Token> nestedTokens = this.flattenExpression(expression);
        if (nestedTokens.isEmpty()) {
            return;
        }
        BSLParser.UnaryModifierContext unaryModifier = member.unaryModifier();
        if (unaryModifier != null && unaryModifier.NOT_KEYWORD() != null) {
            CommonToken splitter = new CommonToken(-1);
            result.add((Token)splitter);
            result.addAll(nestedTokens);
            result.add((Token)splitter);
        } else {
            result.addAll(nestedTokens);
        }
    }

    private static void flattenOperation(List<Token> result, BSLParser.OperationContext operation) {
        BSLParser.BoolOperationContext boolOperation = operation.boolOperation();
        if (boolOperation != null) {
            result.add(boolOperation.getStart());
        }
    }

    private void resetMethodComplexityCounters() {
        this.complexity = 0;
        this.nestedLevel = 0;
    }

    private void incrementFileComplexity() {
        this.fileComplexity += this.complexity;
    }

    private void incrementFileCodeBlockComplexity() {
        this.fileCodeBlockComplexity += this.complexity;
    }

    private void structuralIncrement(Token token) {
        this.complexity += 1 + this.nestedLevel;
        this.addSecondaryLocation(token, 1 + this.nestedLevel, this.nestedLevel);
        ++this.nestedLevel;
    }

    private void fundamentalIncrement(Token token) {
        ++this.complexity;
        this.addSecondaryLocation(token);
    }

    private void hybridIncrement(Token token) {
        ++this.complexity;
        ++this.nestedLevel;
        this.addSecondaryLocation(token);
    }

    private void addSecondaryLocation(Token token) {
        this.addSecondaryLocation(token, 1, 0);
    }

    private void addSecondaryLocation(Token token, int increment, int nested) {
        String message = nested > 0 ? String.format("+%d (nesting = %d)", increment, nested) : String.format("+%d", increment);
        ComplexitySecondaryLocation secondaryLocation = new ComplexitySecondaryLocation(Ranges.create(token), this.stringInterner.intern(message));
        List locations = this.currentMethod != null ? this.methodsComplexitySecondaryLocations.computeIfAbsent(this.currentMethod, methodSymbol -> new ArrayList()) : this.fileBlockComplexitySecondaryLocations;
        locations.add((ComplexitySecondaryLocation)secondaryLocation);
    }

    @ConstructorProperties(value={"documentContext"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CognitiveComplexityComputer(DocumentContext documentContext) {
        this.documentContext = documentContext;
    }

    @Autowired
    @SuppressFBWarnings(justification="generated code")
    @Generated
    void setStringInterner(StringInterner stringInterner) {
        this.stringInterner = stringInterner;
    }

    static {
        CognitiveComplexityComputer.ajc$preClinit();
    }

    static final /* synthetic */ ComplexityData compute_aroundBody0(CognitiveComplexityComputer ajc$this, JoinPoint joinPoint) {
        ajc$this.fileComplexity = 0;
        ajc$this.fileCodeBlockComplexity = 0;
        ajc$this.resetMethodComplexityCounters();
        ajc$this.methodsComplexity.clear();
        ajc$this.ignoredContexts.clear();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)ajc$this, (ParseTree)ajc$this.documentContext.getAst());
        return new ComplexityData(ajc$this.fileComplexity, ajc$this.fileCodeBlockComplexity, ajc$this.fileBlockComplexitySecondaryLocations, ajc$this.methodsComplexity, ajc$this.methodsComplexitySecondaryLocations);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CognitiveComplexityComputer.java", CognitiveComplexityComputer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compute", "com.github._1c_syntax.bsl.languageserver.context.computer.CognitiveComplexityComputer", "", "", "", "com.github._1c_syntax.bsl.languageserver.context.computer.ComplexityData"), 94);
    }
}

