/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context.computer;

import com.github._1c_syntax.bsl.languageserver.aop.MeasuresAspect;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.computer.Computer;
import com.github._1c_syntax.bsl.languageserver.context.computer.MethodSymbolComputer$AjcClosure1;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.ParameterDefinition;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.Annotation;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.AnnotationKind;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.AnnotationParameterDefinition;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.CompilerDirectiveKind;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.MethodDescription;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.ParameterDescription;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserBaseVisitor;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.lsp4j.Range;

public final class MethodSymbolComputer
extends BSLParserBaseVisitor<ParseTree>
implements Computer<List<MethodSymbol>> {
    private static final Set<Integer> SPECIAL_COMPILER_DIRECTIVES_TOKEN_TYPES;
    private final DocumentContext documentContext;
    private final Set<MethodSymbol> methods = new HashSet<MethodSymbol>();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public MethodSymbolComputer(DocumentContext documentContext) {
        this.documentContext = documentContext;
    }

    @Override
    public List<MethodSymbol> compute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        MethodSymbolComputer$AjcClosure1 methodSymbolComputer$AjcClosure1 = new MethodSymbolComputer$AjcClosure1(objectArray);
        return (List)MeasuresAspect.aspectOf().measureComputers(methodSymbolComputer$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public ParseTree visitFunction(BSLParser.FunctionContext ctx) {
        BSLParser.FuncDeclarationContext declaration = ctx.funcDeclaration();
        TerminalNode startNode = declaration.FUNCTION_KEYWORD();
        TerminalNode stopNode = ctx.ENDFUNCTION_KEYWORD();
        if (startNode == null || startNode instanceof ErrorNode || stopNode == null || stopNode instanceof ErrorNode) {
            return ctx;
        }
        MethodSymbol methodSymbol = this.createMethodSymbol(startNode, stopNode, declaration.subName().getStart(), declaration.paramList(), true, declaration.EXPORT_KEYWORD() != null, MethodSymbolComputer.getCompilerDirective(declaration.compilerDirective()), MethodSymbolComputer.getAnnotations(declaration.annotation()));
        this.methods.add(methodSymbol);
        return ctx;
    }

    public ParseTree visitProcedure(BSLParser.ProcedureContext ctx) {
        BSLParser.ProcDeclarationContext declaration = ctx.procDeclaration();
        TerminalNode startNode = declaration.PROCEDURE_KEYWORD();
        TerminalNode stopNode = ctx.ENDPROCEDURE_KEYWORD();
        if (startNode == null || startNode instanceof ErrorNode || stopNode == null || stopNode instanceof ErrorNode) {
            return ctx;
        }
        MethodSymbol methodSymbol = this.createMethodSymbol(startNode, stopNode, declaration.subName().getStart(), declaration.paramList(), false, declaration.EXPORT_KEYWORD() != null, MethodSymbolComputer.getCompilerDirective(declaration.compilerDirective()), MethodSymbolComputer.getAnnotations(declaration.annotation()));
        this.methods.add(methodSymbol);
        return ctx;
    }

    private static Optional<CompilerDirectiveKind> getCompilerDirective(List<? extends BSLParser.CompilerDirectiveContext> compilerDirectiveContexts) {
        if (compilerDirectiveContexts.isEmpty()) {
            return Optional.empty();
        }
        Integer tokenType = compilerDirectiveContexts.stream().map(compilerDirectiveContext -> compilerDirectiveContext.getStop().getType()).filter(SPECIAL_COMPILER_DIRECTIVES_TOKEN_TYPES::contains).findAny().orElseGet(() -> ((BSLParser.CompilerDirectiveContext)compilerDirectiveContexts.get(0)).getStop().getType());
        return CompilerDirectiveKind.of(tokenType);
    }

    private MethodSymbol createMethodSymbol(TerminalNode startNode, TerminalNode stopNode, Token subName, BSLParser.ParamListContext paramList, boolean function, boolean export, Optional<CompilerDirectiveKind> compilerDirective, List<Annotation> annotations) {
        Optional<MethodDescription> description = this.createDescription(startNode.getSymbol());
        boolean deprecated = description.map(MethodDescription::isDeprecated).orElse(false);
        return MethodSymbol.builder().name(subName.getText().intern()).owner(this.documentContext).range(Ranges.create(startNode, stopNode)).subNameRange(Ranges.create(subName)).function(function).export(export).description(description).deprecated(deprecated).parameters(MethodSymbolComputer.createParameters(paramList, description)).compilerDirectiveKind(compilerDirective).annotations(annotations).build();
    }

    private Optional<MethodDescription> createDescription(Token token) {
        List<Token> comments = Trees.getComments(this.documentContext.getTokens(), token);
        if (comments.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MethodDescription(comments));
    }

    private static List<ParameterDefinition> createParameters(@Nullable BSLParser.ParamListContext paramList, Optional<MethodDescription> description) {
        if (paramList == null) {
            return Collections.emptyList();
        }
        return paramList.param().stream().map(param -> {
            String parameterName = MethodSymbolComputer.getParameterName(param.IDENTIFIER());
            return ParameterDefinition.builder().name(parameterName).byValue(param.VAL_KEYWORD() != null).defaultValue(MethodSymbolComputer.getDefaultValue(param)).range(MethodSymbolComputer.getParameterRange(param)).description(MethodSymbolComputer.getParameterDescription(parameterName, description)).build();
        }).collect(Collectors.toList());
    }

    private static ParameterDefinition.DefaultValue getDefaultValue(BSLParser.ParamContext param) {
        ParameterDefinition.DefaultValue defaultValue;
        if (param.defaultValue() == null) {
            return ParameterDefinition.DefaultValue.EMPTY;
        }
        BSLParser.ConstValueContext constValue = param.defaultValue().constValue();
        if (constValue.DATETIME() != null) {
            String value = constValue.DATETIME().getSymbol().getText();
            defaultValue = new ParameterDefinition.DefaultValue(ParameterDefinition.ParameterType.DATETIME, value.intern());
        } else if (constValue.FALSE() != null) {
            String value = constValue.FALSE().getSymbol().getText();
            defaultValue = new ParameterDefinition.DefaultValue(ParameterDefinition.ParameterType.BOOLEAN, value.intern());
        } else if (constValue.TRUE() != null) {
            String value = constValue.TRUE().getSymbol().getText();
            defaultValue = new ParameterDefinition.DefaultValue(ParameterDefinition.ParameterType.BOOLEAN, value.intern());
        } else if (constValue.UNDEFINED() != null) {
            String value = constValue.UNDEFINED().getSymbol().getText();
            defaultValue = new ParameterDefinition.DefaultValue(ParameterDefinition.ParameterType.UNDEFINED, value.intern());
        } else if (constValue.NULL() != null) {
            String value = constValue.NULL().getSymbol().getText();
            defaultValue = new ParameterDefinition.DefaultValue(ParameterDefinition.ParameterType.NULL, value.intern());
        } else if (constValue.string() != null) {
            String value = constValue.string().STRING().stream().map(TerminalNode::getSymbol).map(Token::getText).collect(Collectors.joining("\n"));
            defaultValue = new ParameterDefinition.DefaultValue(ParameterDefinition.ParameterType.STRING, value.intern());
        } else if (constValue.numeric() != null) {
            Object value = constValue.numeric().getText();
            if (constValue.MINUS() != null) {
                value = constValue.MINUS().getSymbol().getText() + (String)value;
            }
            if (constValue.PLUS() != null) {
                value = constValue.PLUS().getSymbol().getText() + (String)value;
            }
            defaultValue = new ParameterDefinition.DefaultValue(ParameterDefinition.ParameterType.NUMERIC, ((String)value).intern());
        } else {
            defaultValue = ParameterDefinition.DefaultValue.EMPTY;
        }
        return defaultValue;
    }

    private static String getParameterName(TerminalNode identifier) {
        return Optional.ofNullable(identifier).map(ParseTree::getText).map(String::intern).orElse("<UNKNOWN_IDENTIFIER>");
    }

    private static Range getParameterRange(BSLParser.ParamContext param) {
        if (param.IDENTIFIER() == null) {
            return Ranges.create(param.start);
        }
        return Ranges.create(param.IDENTIFIER());
    }

    private static Optional<ParameterDescription> getParameterDescription(String parameterName, Optional<MethodDescription> description) {
        return description.map(MethodDescription::getParameters).stream().flatMap(Collection::stream).filter(parameterDescription -> parameterDescription.getName().equalsIgnoreCase(parameterName)).findFirst();
    }

    private static List<Annotation> getAnnotations(List<? extends BSLParser.AnnotationContext> annotationContext) {
        return annotationContext.stream().map(MethodSymbolComputer::createAnnotation).collect(Collectors.toList());
    }

    private static Annotation createAnnotation(BSLParser.AnnotationContext annotation) {
        return Annotation.builder().name(annotation.annotationName().getText().intern()).kind(AnnotationKind.of(annotation.annotationName().getStop().getType())).parameters(MethodSymbolComputer.getAnnotationParameter(annotation.annotationParams())).build();
    }

    private static List<AnnotationParameterDefinition> getAnnotationParameter(BSLParser.AnnotationParamsContext annotationParamsContext) {
        if (annotationParamsContext == null) {
            return Collections.emptyList();
        }
        return annotationParamsContext.annotationParam().stream().map(MethodSymbolComputer::getAnnotationParam).collect(Collectors.toList());
    }

    private static AnnotationParameterDefinition getAnnotationParam(BSLParser.AnnotationParamContext o) {
        String name = Optional.ofNullable(o.annotationParamName()).map(BSLParserRuleContext::getText).orElse("");
        String value = Optional.ofNullable(o.constValue()).map(BSLParserRuleContext::getText).map(MethodSymbolComputer::excludeTrailingQuotes).orElse("");
        boolean optional = o.constValue() != null;
        return new AnnotationParameterDefinition(name, value, optional);
    }

    private static String excludeTrailingQuotes(String text) {
        if (text.length() > 2 && text.charAt(0) == '\"') {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    static {
        MethodSymbolComputer.ajc$preClinit();
        SPECIAL_COMPILER_DIRECTIVES_TOKEN_TYPES = Set.of(Integer.valueOf(113), Integer.valueOf(115));
    }

    static final /* synthetic */ List compute_aroundBody0(MethodSymbolComputer ajc$this, JoinPoint joinPoint) {
        ajc$this.methods.clear();
        ajc$this.visitFile(ajc$this.documentContext.getAst());
        return new ArrayList<MethodSymbol>(ajc$this.methods);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MethodSymbolComputer.java", MethodSymbolComputer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compute", "com.github._1c_syntax.bsl.languageserver.context.computer.MethodSymbolComputer", "", "", "", "java.util.List"), 72);
    }
}

