/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.MAJOR, minutesToFix=5, tags={DiagnosticTag.STANDARD, DiagnosticTag.ERROR})
public class DeletingCollectionItemDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern DELETE_CALL_PATTERN = CaseInsensitivePattern.compile((String)"(\u0443\u0434\u0430\u043b\u0438\u0442\u044c|delete)");
    private static final Predicate<BSLParser.MethodCallContext> MATCH_METHOD_CALL_DELETE = e -> DELETE_CALL_PATTERN.matcher(e.methodName().getText()).matches();

    private static boolean namesEqual(BSLParser.CallStatementContext callStatement, String collectionExpression) {
        String callStatementText = callStatement.getText().toLowerCase(Locale.getDefault());
        String prefix = collectionExpression.toLowerCase(Locale.getDefault()) + "." + callStatement.accessCall().methodCall().methodName().getText().toLowerCase(Locale.getDefault()) + "(";
        return callStatementText.startsWith(prefix);
    }

    public ParseTree visitForEachStatement(BSLParser.ForEachStatementContext ctx) {
        String collectionExpression = ctx.expression().getText();
        Trees.findAllRuleNodes((ParseTree)ctx.codeBlock(), 92).stream().filter(BSLParser.MethodCallContext.class::isInstance).map(BSLParser.MethodCallContext.class::cast).filter(MATCH_METHOD_CALL_DELETE).map(node -> node.getParent().getParent()).filter(BSLParser.CallStatementContext.class::isInstance).map(BSLParser.CallStatementContext.class::cast).filter(callStatement -> DeletingCollectionItemDiagnostic.namesEqual(callStatement, collectionExpression)).forEach(callStatement -> this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)callStatement, this.info.getMessage(collectionExpression)));
        return (ParseTree)super.visitForEachStatement(ctx);
    }
}

