/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCompatibilityMode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, minutesToFix=1, scope=DiagnosticScope.BSL, compatibilityMode=DiagnosticCompatibilityMode.COMPATIBILITY_MODE_8_3_10, tags={DiagnosticTag.DEPRECATED})
public class DeprecatedMethods8310Diagnostic
extends AbstractVisitorDiagnostic {
    private static final String SET_SHORT_APPLICATION_CAPTION_RU = "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c\u041a\u0440\u0430\u0442\u043a\u0438\u0439\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f";
    private static final String SET_SHORT_APPLICATION_CAPTION_EN = "SetShortApplicationCaption";
    private static final String GET_SHORT_APPLICATION_CAPTION_RU = "\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c\u041a\u0440\u0430\u0442\u043a\u0438\u0439\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f";
    private static final String GET_SHORT_APPLICATION_CAPTION_EN = "GetShortApplicationCaption";
    private static final String SET_CLIENT_APPLICATION_CAPTION_RU = "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0433\u043e\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f";
    private static final String SET_CLIENT_APPLICATION_CAPTION_EN = "SetClientApplicationCaption";
    private static final String GET_CLIENT_APPLICATION_CAPTION_RU = "\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0433\u043e\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f";
    private static final String GET_CLIENT_APPLICATION_CAPTION_EN = "GetClientApplicationCaption";
    private static final String BASE_FONT_CURRENT_VARIANT_RU = "\u0422\u0435\u043a\u0443\u0449\u0438\u0439\u0412\u0430\u0440\u0438\u0430\u043d\u0442\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0433\u043e\u0428\u0440\u0438\u0444\u0442\u0430\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0433\u043e\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f";
    private static final String BASE_FONT_CURRENT_VARIANT_EN = "ClientApplicationBaseFontCurrentVariant";
    private static final String CLIENT_INTERFACE_VARIANT_RU = "\u0422\u0435\u043a\u0443\u0449\u0438\u0439\u0412\u0430\u0440\u0438\u0430\u043d\u0442\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0433\u043e\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f";
    private static final String CLIENT_INTERFACE_VARIANT_EN = "ClientApplicationInterfaceCurrentVariant";
    private static final Pattern METHOD_PATTERN = CaseInsensitivePattern.compile((String)DeprecatedMethods8310Diagnostic.getRegex());
    private static final HashMap<String, String> newMethods = new HashMap();

    private static String getRegex() {
        HashMap<String, String> methodsPair = new HashMap<String, String>();
        methodsPair.put(SET_SHORT_APPLICATION_CAPTION_RU, SET_SHORT_APPLICATION_CAPTION_EN);
        methodsPair.put(GET_SHORT_APPLICATION_CAPTION_RU, GET_SHORT_APPLICATION_CAPTION_EN);
        methodsPair.put(SET_CLIENT_APPLICATION_CAPTION_RU, SET_CLIENT_APPLICATION_CAPTION_EN);
        methodsPair.put(GET_CLIENT_APPLICATION_CAPTION_RU, GET_CLIENT_APPLICATION_CAPTION_EN);
        methodsPair.put(BASE_FONT_CURRENT_VARIANT_RU, BASE_FONT_CURRENT_VARIANT_EN);
        methodsPair.put(CLIENT_INTERFACE_VARIANT_RU, CLIENT_INTERFACE_VARIANT_EN);
        StringJoiner regex = new StringJoiner("|");
        methodsPair.forEach((k, v) -> {
            regex.add((CharSequence)k);
            regex.add((CharSequence)v);
        });
        return regex.toString();
    }

    public ParseTree visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        Matcher matcher = METHOD_PATTERN.matcher(ctx.methodName().getText());
        if (matcher.matches()) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx, this.info.getMessage(matcher.group(), newMethods.getOrDefault(matcher.group().toLowerCase(Locale.ENGLISH), "")));
        }
        return (ParseTree)super.visitGlobalMethodCall(ctx);
    }

    static {
        newMethods.put(SET_SHORT_APPLICATION_CAPTION_RU.toLowerCase(Locale.ENGLISH), "\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0435\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435.\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c\u041a\u0440\u0430\u0442\u043a\u0438\u0439\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a");
        newMethods.put(GET_SHORT_APPLICATION_CAPTION_RU.toLowerCase(Locale.ENGLISH), "\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0435\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435.\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c\u041a\u0440\u0430\u0442\u043a\u0438\u0439\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a");
        newMethods.put(SET_CLIENT_APPLICATION_CAPTION_RU.toLowerCase(Locale.ENGLISH), "\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0435\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435.\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a");
        newMethods.put(GET_CLIENT_APPLICATION_CAPTION_RU.toLowerCase(Locale.ENGLISH), "\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0435\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435.\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a");
        newMethods.put(BASE_FONT_CURRENT_VARIANT_RU.toLowerCase(Locale.ENGLISH), "\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0435\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435.\u0422\u0435\u043a\u0443\u0449\u0438\u0439\u0412\u0430\u0440\u0438\u0430\u043d\u0442\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0433\u043e\u0428\u0440\u0438\u0444\u0442\u0430");
        newMethods.put(CLIENT_INTERFACE_VARIANT_RU.toLowerCase(Locale.ENGLISH), "\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0435\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435.\u0422\u0435\u043a\u0443\u0449\u0438\u0439\u0412\u0430\u0440\u0438\u0430\u043d\u0442\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430");
        newMethods.put(SET_SHORT_APPLICATION_CAPTION_EN.toLowerCase(Locale.ENGLISH), "ClientApplication.SetShortCaption");
        newMethods.put(GET_SHORT_APPLICATION_CAPTION_EN.toLowerCase(Locale.ENGLISH), "ClientApplication.GetShortCaption");
        newMethods.put(SET_CLIENT_APPLICATION_CAPTION_EN.toLowerCase(Locale.ENGLISH), "ClientApplication.SetCaption");
        newMethods.put(GET_CLIENT_APPLICATION_CAPTION_EN.toLowerCase(Locale.ENGLISH), "ClientApplication.GetCaption");
        newMethods.put(BASE_FONT_CURRENT_VARIANT_EN.toLowerCase(Locale.ENGLISH), "ClientApplication.CurrentBaseFontVariant");
        newMethods.put(CLIENT_INTERFACE_VARIANT_EN.toLowerCase(Locale.ENGLISH), "ClientApplication.CurrentInterfaceVariant");
    }
}

