/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=1, tags={DiagnosticTag.BRAINOVERLOAD, DiagnosticTag.SUSPICIOUS, DiagnosticTag.BADPRACTICE})
public class DuplicatedInsertionIntoCollectionDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern INSERT_ADD_METHOD_PATTERN = CaseInsensitivePattern.compile((String)"\u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c|\u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c|insert|add");
    private static final Pattern INSERT_METHOD_PATTERN = CaseInsensitivePattern.compile((String)"\u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c|insert");
    private static final Pattern IGNORED_BSL_VALUES_PATTERN = CaseInsensitivePattern.compile((String)"\u043d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e|undefined|0|\u0441\u0438\u043c\u0432\u043e\u043b\u044b\\.[\\w\u0430-\u044f\u0451]+|chars\\.[\\w\u0430-\u044f\u0451]+");
    private static final List<Integer> BREAKERS_INDEXES = Arrays.asList(55, 45, 44, 46);
    private static final List<Integer> BREAKERS_ROOTS = Arrays.asList(53, 52, 51, 54);
    private static final int LENGTH_OF_EMPTY_STRING_WITH_QUOTES = 2;
    private static final boolean IS_ALLOWED_METHOD_ADD = true;
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean isAllowedMethodADD = true;
    private Pattern methodPattern = INSERT_ADD_METHOD_PATTERN;
    private BSLParser.CodeBlockContext codeBlock;
    private Range blockRange;
    private List<BSLParser.AssignmentContext> blockAssignments;
    private List<BSLParserRuleContext> blockBreakers;
    private List<BSLParser.CallParamContext> blockCallParams;
    private List<String> firstParamInnerIdentifiers;

    @Override
    public void configure(Map<String, Object> configuration) {
        super.configure(configuration);
        if (!this.isAllowedMethodADD) {
            this.methodPattern = INSERT_METHOD_PATTERN;
        }
    }

    public ParseTree visitCodeBlock(BSLParser.CodeBlockContext codeBlock) {
        this.codeBlock = codeBlock;
        List<GroupingData> possibleDuplicateStatements = this.getPossibleDuplicates();
        if (!possibleDuplicateStatements.isEmpty()) {
            this.blockRange = Ranges.create((ParserRuleContext)codeBlock);
            this.explorePossibleDuplicateStatements(possibleDuplicateStatements).forEach(this::fireIssue);
        }
        this.clearCodeBlockFields();
        return (ParseTree)super.visitCodeBlock(codeBlock);
    }

    private List<GroupingData> getPossibleDuplicates() {
        return this.codeBlock.statement().stream().map(BSLParser.StatementContext::callStatement).filter(Objects::nonNull).filter(callStatement -> callStatement.accessCall() != null).map(callStatement -> this.groupingCalls((BSLParser.CallStatementContext)callStatement, callStatement.accessCall())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private GroupingData groupingCalls(BSLParser.CallStatementContext callStatement, BSLParser.AccessCallContext accessCallContext) {
        String parens;
        TerminalNode identifierContext;
        BSLParser.MethodCallContext methodCallContext = accessCallContext.methodCall();
        List callParams = methodCallContext.doCall().callParamList().callParam();
        BSLParser.CallParamContext firstParamContext = (BSLParser.CallParamContext)callParams.get(0);
        if (firstParamContext.getChildCount() == 0) {
            return null;
        }
        String methodName = methodCallContext.methodName().getText();
        if (!this.isAppropriateMethodCall(methodName)) {
            return null;
        }
        String firstParam = firstParamContext.getText();
        if (DuplicatedInsertionIntoCollectionDiagnostic.isBlankBSLString(firstParam) || DuplicatedInsertionIntoCollectionDiagnostic.isIgnoredBSLValues(firstParam)) {
            return null;
        }
        if (callStatement.IDENTIFIER() != null) {
            identifierContext = callStatement.IDENTIFIER();
            parens = "";
        } else {
            identifierContext = callStatement.globalMethodCall().methodName().IDENTIFIER();
            parens = "()";
        }
        String collectionName = DuplicatedInsertionIntoCollectionDiagnostic.getFullIdentifier(identifierContext.getText().concat(parens), callStatement.modifier());
        return new GroupingData(callStatement, collectionName, collectionName.concat("."), methodName, firstParam, firstParam.concat("."), firstParamContext);
    }

    private boolean isAppropriateMethodCall(String methodName) {
        return this.methodPattern.matcher(methodName).matches();
    }

    private static boolean isBlankBSLString(String text) {
        int length = text.length();
        return length >= 2 && text.charAt(0) == '\"' && text.charAt(length - 1) == '\"' && text.substring(1, length - 1).isBlank();
    }

    private static boolean isIgnoredBSLValues(String text) {
        return IGNORED_BSL_VALUES_PATTERN.matcher(text).matches();
    }

    private Stream<List<GroupingData>> explorePossibleDuplicateStatements(List<GroupingData> statements) {
        CaseInsensitiveMap mapOfMapsByIdentifier = statements.stream().collect(Collectors.groupingBy(GroupingData::getCollectionName, CaseInsensitiveMap::new, Collectors.groupingBy(GroupingData::getMethodName, CaseInsensitiveMap::new, Collectors.groupingBy(GroupingData::getFirstParamName, CaseInsensitiveMap::new, Collectors.mapping(groupingData -> groupingData, Collectors.toList())))));
        return mapOfMapsByIdentifier.values().stream().flatMap(mapByMethod -> mapByMethod.values().stream()).flatMap(mapByFirstParam -> mapByFirstParam.values().stream()).filter(duplicates -> duplicates.size() > 1).map(this::excludeValidChanges).filter(duplicates -> duplicates.size() > 1);
    }

    private List<GroupingData> excludeValidChanges(List<GroupingData> duplicates) {
        ArrayList<GroupingData> result = new ArrayList<GroupingData>();
        for (int i = 0; i < duplicates.size() && this.excludeValidElements(duplicates, i, result); ++i) {
        }
        this.firstParamInnerIdentifiers = null;
        return result;
    }

    private boolean excludeValidElements(List<GroupingData> duplicates, int currIndex, List<GroupingData> listForIssue) {
        GroupingData next;
        if (duplicates.size() - currIndex <= 1) {
            return false;
        }
        GroupingData first = duplicates.get(currIndex);
        boolean alreadyAdd = !listForIssue.isEmpty() && listForIssue.get(listForIssue.size() - 1) == first;
        for (int i = currIndex + 1; i < duplicates.size() && !this.hasValidChange(first, next = duplicates.get(i)); ++i) {
            if (!alreadyAdd) {
                alreadyAdd = true;
                listForIssue.add(first);
            }
            listForIssue.add(next);
        }
        return true;
    }

    private boolean hasValidChange(GroupingData first, GroupingData next) {
        Range border = Ranges.create(first.callStatement.getStop(), next.callStatement.getStart());
        return this.hasAssignBetweenCalls(first, border) || this.hasBreakersBetweenCalls(border) || this.usedAsFunctionParamsBetweenCalls(border, first);
    }

    private boolean hasAssignBetweenCalls(GroupingData groupingData, Range border) {
        return this.getAssignments().stream().filter(assignmentContext -> Ranges.containsRange(border, Ranges.create((ParserRuleContext)assignmentContext))).map(assignmentContext -> assignmentContext.lValue().getText()).anyMatch(assignText -> this.usedIdentifiers((String)assignText, groupingData));
    }

    private boolean usedIdentifiers(String expression, GroupingData groupingData) {
        String expressionWithDot = expression.concat(".");
        if (DuplicatedInsertionIntoCollectionDiagnostic.startWithIgnoreCase(groupingData.collectionNameWithDot, expressionWithDot)) {
            return true;
        }
        return this.getAllInnerIdentifiersWithDot(groupingData.firstParamContext).stream().anyMatch(identifierWithDot -> DuplicatedInsertionIntoCollectionDiagnostic.startWithIgnoreCase(identifierWithDot, expressionWithDot) || DuplicatedInsertionIntoCollectionDiagnostic.startWithIgnoreCase(expressionWithDot, identifierWithDot));
    }

    private static boolean startWithIgnoreCase(String identifier, String textWithDot) {
        return identifier.length() >= textWithDot.length() && identifier.substring(0, textWithDot.length()).equalsIgnoreCase(textWithDot);
    }

    private boolean hasBreakersBetweenCalls(Range border) {
        return this.getBreakers().stream().filter(bslParserRuleContext -> Ranges.containsRange(border, Ranges.create((ParserRuleContext)bslParserRuleContext))).anyMatch(this::hasBreakerIntoCodeBlock);
    }

    private boolean hasBreakerIntoCodeBlock(BSLParserRuleContext breakerContext) {
        if (breakerContext.getRuleIndex() == 55) {
            return true;
        }
        BSLParserRuleContext rootParent = Trees.getRootParent(breakerContext, BREAKERS_ROOTS);
        if (rootParent == null) {
            return true;
        }
        return !Ranges.containsRange(this.blockRange, Ranges.create((ParserRuleContext)rootParent));
    }

    private boolean usedAsFunctionParamsBetweenCalls(Range border, GroupingData groupingData) {
        return this.getCallParams().stream().filter(callParamContext -> Ranges.containsRange(border, Ranges.create((ParserRuleContext)callParamContext))).anyMatch(callParamContext -> this.usedAsFunctionParams((BSLParser.CallParamContext)callParamContext, groupingData));
    }

    private boolean usedAsFunctionParams(BSLParser.CallParamContext callParamContext, GroupingData groupingData) {
        return Optional.of(callParamContext).map(BSLParser.CallParamContext::expression).map(BSLParser.ExpressionContext::member).filter(memberContexts -> this.usedIdentifiers((List<? extends BSLParser.MemberContext>)memberContexts, groupingData)).isPresent();
    }

    private boolean usedIdentifiers(List<? extends BSLParser.MemberContext> memberContexts, GroupingData groupingData) {
        return memberContexts.stream().map(BSLParser.MemberContext::complexIdentifier).filter(Objects::nonNull).filter(complexIdentifierContext -> complexIdentifierContext.IDENTIFIER() != null).map(BSLParserRuleContext::getText).anyMatch(identifier -> this.usedIdentifiers((String)identifier, groupingData));
    }

    private void fireIssue(List<GroupingData> duplicates) {
        GroupingData dataForIssue = duplicates.get(1);
        List<DiagnosticRelatedInformation> relatedInformationList = duplicates.stream().map(GroupingData::getCallStatement).map(context -> RelatedInformation.create(this.documentContext.getUri(), Ranges.create((ParserRuleContext)context), "+1")).collect(Collectors.toList());
        String message = this.info.getMessage(dataForIssue.firstParamName, dataForIssue.collectionName);
        this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)dataForIssue.callStatement, message, relatedInformationList);
    }

    private List<BSLParser.AssignmentContext> getAssignments() {
        if (this.blockAssignments == null) {
            this.blockAssignments = Trees.findAllRuleNodes((ParseTree)this.codeBlock, 81).stream().map(BSLParser.AssignmentContext.class::cast).collect(Collectors.toUnmodifiableList());
        }
        return this.blockAssignments;
    }

    private List<BSLParserRuleContext> getBreakers() {
        if (this.blockBreakers == null) {
            this.blockBreakers = Trees.findAllRuleNodes((ParseTree)this.codeBlock, BREAKERS_INDEXES).stream().map(BSLParserRuleContext.class::cast).collect(Collectors.toUnmodifiableList());
        }
        return this.blockBreakers;
    }

    private List<BSLParser.CallParamContext> getCallParams() {
        if (this.blockCallParams == null) {
            this.blockCallParams = Trees.findAllRuleNodes((ParseTree)this.codeBlock, 83).stream().map(BSLParser.CallParamContext.class::cast).collect(Collectors.toUnmodifiableList());
        }
        return this.blockCallParams;
    }

    private List<String> getAllInnerIdentifiersWithDot(BSLParser.CallParamContext param) {
        if (this.firstParamInnerIdentifiers == null) {
            List<BSLParser.ComplexIdentifierContext> identifiers = Trees.findAllRuleNodes((ParseTree)param, 95).stream().map(BSLParser.ComplexIdentifierContext.class::cast).filter(complexIdentifierContext -> complexIdentifierContext.IDENTIFIER() != null).toList();
            ArrayList<String> reducedIdentifiers = new ArrayList<String>();
            for (BSLParser.ComplexIdentifierContext identifier : identifiers) {
                List modifiers = identifier.modifier();
                String firstIdentifier = identifier.IDENTIFIER().getText();
                String fullIdentifier = DuplicatedInsertionIntoCollectionDiagnostic.getFullIdentifier(firstIdentifier, modifiers);
                reducedIdentifiers.add(fullIdentifier);
                String reducedIdentifier = firstIdentifier;
                for (BSLParser.ModifierContext modifier : modifiers) {
                    String text = modifier.getText();
                    reducedIdentifier = reducedIdentifier.concat(".").concat(text);
                    reducedIdentifiers.add(reducedIdentifier);
                }
            }
            this.firstParamInnerIdentifiers = reducedIdentifiers;
        }
        return this.firstParamInnerIdentifiers;
    }

    private void clearCodeBlockFields() {
        this.codeBlock = null;
        this.blockRange = null;
        this.blockAssignments = null;
        this.blockBreakers = null;
        this.blockCallParams = null;
    }

    private static String getFullIdentifier(String firstIdentifier, List<? extends BSLParser.ModifierContext> modifiers) {
        return modifiers.stream().map(BSLParserRuleContext::getText).reduce(firstIdentifier, (x, y) -> x.concat(".").concat((String)y)).replace("..", ".");
    }

    private static final class GroupingData {
        private final BSLParser.CallStatementContext callStatement;
        private final String collectionName;
        private final String collectionNameWithDot;
        private final String methodName;
        private final String firstParamName;
        private final String firstParamNameWithDot;
        private final BSLParser.CallParamContext firstParamContext;

        @ConstructorProperties(value={"callStatement", "collectionName", "collectionNameWithDot", "methodName", "firstParamName", "firstParamNameWithDot", "firstParamContext"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GroupingData(BSLParser.CallStatementContext callStatement, String collectionName, String collectionNameWithDot, String methodName, String firstParamName, String firstParamNameWithDot, BSLParser.CallParamContext firstParamContext) {
            this.callStatement = callStatement;
            this.collectionName = collectionName;
            this.collectionNameWithDot = collectionNameWithDot;
            this.methodName = methodName;
            this.firstParamName = firstParamName;
            this.firstParamNameWithDot = firstParamNameWithDot;
            this.firstParamContext = firstParamContext;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BSLParser.CallStatementContext getCallStatement() {
            return this.callStatement;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getCollectionName() {
            return this.collectionName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getCollectionNameWithDot() {
            return this.collectionNameWithDot;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getMethodName() {
            return this.methodName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getFirstParamName() {
            return this.firstParamName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getFirstParamNameWithDot() {
            return this.firstParamNameWithDot;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BSLParser.CallParamContext getFirstParamContext() {
            return this.firstParamContext;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupingData)) {
                return false;
            }
            GroupingData other = (GroupingData)o;
            BSLParser.CallStatementContext this$callStatement = this.getCallStatement();
            BSLParser.CallStatementContext other$callStatement = other.getCallStatement();
            if (this$callStatement == null ? other$callStatement != null : !this$callStatement.equals(other$callStatement)) {
                return false;
            }
            String this$collectionName = this.getCollectionName();
            String other$collectionName = other.getCollectionName();
            if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
                return false;
            }
            String this$collectionNameWithDot = this.getCollectionNameWithDot();
            String other$collectionNameWithDot = other.getCollectionNameWithDot();
            if (this$collectionNameWithDot == null ? other$collectionNameWithDot != null : !this$collectionNameWithDot.equals(other$collectionNameWithDot)) {
                return false;
            }
            String this$methodName = this.getMethodName();
            String other$methodName = other.getMethodName();
            if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
                return false;
            }
            String this$firstParamName = this.getFirstParamName();
            String other$firstParamName = other.getFirstParamName();
            if (this$firstParamName == null ? other$firstParamName != null : !this$firstParamName.equals(other$firstParamName)) {
                return false;
            }
            String this$firstParamNameWithDot = this.getFirstParamNameWithDot();
            String other$firstParamNameWithDot = other.getFirstParamNameWithDot();
            if (this$firstParamNameWithDot == null ? other$firstParamNameWithDot != null : !this$firstParamNameWithDot.equals(other$firstParamNameWithDot)) {
                return false;
            }
            BSLParser.CallParamContext this$firstParamContext = this.getFirstParamContext();
            BSLParser.CallParamContext other$firstParamContext = other.getFirstParamContext();
            return !(this$firstParamContext == null ? other$firstParamContext != null : !this$firstParamContext.equals(other$firstParamContext));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BSLParser.CallStatementContext $callStatement = this.getCallStatement();
            result = result * 59 + ($callStatement == null ? 43 : $callStatement.hashCode());
            String $collectionName = this.getCollectionName();
            result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
            String $collectionNameWithDot = this.getCollectionNameWithDot();
            result = result * 59 + ($collectionNameWithDot == null ? 43 : $collectionNameWithDot.hashCode());
            String $methodName = this.getMethodName();
            result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
            String $firstParamName = this.getFirstParamName();
            result = result * 59 + ($firstParamName == null ? 43 : $firstParamName.hashCode());
            String $firstParamNameWithDot = this.getFirstParamNameWithDot();
            result = result * 59 + ($firstParamNameWithDot == null ? 43 : $firstParamNameWithDot.hashCode());
            BSLParser.CallParamContext $firstParamContext = this.getFirstParamContext();
            result = result * 59 + ($firstParamContext == null ? 43 : $firstParamContext.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "DuplicatedInsertionIntoCollectionDiagnostic.GroupingData(callStatement=" + this.getCallStatement() + ", collectionName=" + this.getCollectionName() + ", collectionNameWithDot=" + this.getCollectionNameWithDot() + ", methodName=" + this.getMethodName() + ", firstParamName=" + this.getFirstParamName() + ", firstParamNameWithDot=" + this.getFirstParamNameWithDot() + ", firstParamContext=" + this.getFirstParamContext() + ")";
        }
    }
}

