/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import java.util.List;
import java.util.stream.Stream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.Tree;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=5, tags={DiagnosticTag.BADPRACTICE, DiagnosticTag.SUSPICIOUS})
public class EmptyCodeBlockDiagnostic
extends AbstractVisitorDiagnostic {
    private static final boolean DEFAULT_COMMENT_AS_CODE = false;
    @DiagnosticParameter(type=Boolean.class, defaultValue="false")
    private boolean commentAsCode = false;

    public ParseTree visitCodeBlock(BSLParser.CodeBlockContext ctx) {
        Range rangeCodeBlock;
        Stream comments;
        boolean isFileBlock;
        boolean bl = isFileBlock = ctx.getParent() instanceof BSLParser.FileContext || ctx.getParent() instanceof BSLParser.FileCodeBlockBeforeSubContext || ctx.getParent() instanceof BSLParser.FileCodeBlockContext;
        if (ctx.getChildCount() > 0 || isFileBlock || ctx.getParent() instanceof BSLParser.SubCodeBlockContext || ctx.getParent() instanceof BSLParser.ExceptCodeBlockContext) {
            return (ParseTree)super.visitCodeBlock(ctx);
        }
        if (this.commentAsCode && (comments = this.documentContext.getComments().stream()).anyMatch(arg_0 -> EmptyCodeBlockDiagnostic.lambda$visitCodeBlock$0(rangeCodeBlock = Ranges.create(ctx.getStop(), ctx.getStart()), arg_0))) {
            return (ParseTree)super.visitCodeBlock(ctx);
        }
        int lineOfStop = ctx.getStop().getLine();
        List<Tree> list = Trees.getChildren((Tree)ctx.getParent()).stream().filter(TerminalNode.class::isInstance).filter(node -> ((TerminalNode)node).getSymbol().getLine() == lineOfStop).toList();
        if (!list.isEmpty()) {
            TerminalNode first = (TerminalNode)list.get(0);
            TerminalNode last = (TerminalNode)list.get(list.size() - 1);
            this.diagnosticStorage.addDiagnostic(first, last);
        } else {
            this.diagnosticStorage.addDiagnostic(ctx.getParent().getStop());
        }
        return (ParseTree)super.visitCodeBlock(ctx);
    }

    private static /* synthetic */ boolean lambda$visitCodeBlock$0(Range rangeCodeBlock, Token token) {
        return Ranges.containsRange(rangeCodeBlock, Ranges.create(token));
    }
}

