/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.QuickFixProvider;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.providers.CodeActionProvider;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, minutesToFix=1, tags={DiagnosticTag.BADPRACTICE})
public class EmptyStatementDiagnostic
extends AbstractVisitorDiagnostic
implements QuickFixProvider {
    public ParseTree visitStatement(BSLParser.StatementContext ctx) {
        if (ctx.getChildCount() == 1 && ctx.SEMICOLON() != null && !Trees.treeContainsErrors(Trees.getPreviousNode((ParseTree)Trees.getRootParent((BSLParserRuleContext)ctx), (ParseTree)ctx, 80))) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx);
        }
        return (ParseTree)super.visitStatement(ctx);
    }

    @Override
    public List<CodeAction> getQuickFixes(List<Diagnostic> diagnostics, CodeActionParams params, DocumentContext documentContext) {
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        diagnostics.forEach(diagnostic -> {
            Position diagnosticRangeEnd = diagnostic.getRange().getEnd();
            Position diagnosticRangeNewEnd = new Position(diagnosticRangeEnd.getLine(), diagnosticRangeEnd.getCharacter() - 1);
            Range range = new Range(diagnosticRangeNewEnd, diagnosticRangeEnd);
            TextEdit textEdit = new TextEdit(range, "");
            textEdits.add(textEdit);
        });
        return CodeActionProvider.createCodeActions(textEdits, this.info.getResourceString("quickFixMessage"), documentContext.getUri(), diagnostics);
    }
}

