/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=5, tags={DiagnosticTag.BRAINOVERLOAD})
public class IfConditionComplexityDiagnostic
extends AbstractVisitorDiagnostic {
    private static final int MAX_IF_CONDITION_COMPLEXITY = 3;
    @DiagnosticParameter(type=Integer.class, defaultValue="3")
    private int maxIfConditionComplexity = 3;

    public ParseTree visitIfBranch(BSLParser.IfBranchContext ctx) {
        this.checkExpressionAndRaise(ctx.expression());
        return (ParseTree)super.visitIfBranch(ctx);
    }

    public ParseTree visitElsifBranch(BSLParser.ElsifBranchContext ctx) {
        this.checkExpressionAndRaise(ctx.expression());
        return (ParseTree)super.visitElsifBranch(ctx);
    }

    private void checkExpressionAndRaise(BSLParser.ExpressionContext expression) {
        if (Trees.findAllRuleNodes((ParseTree)expression, 87).size() + 1 > this.maxIfConditionComplexity) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)expression);
        }
    }
}

