/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.DiagnosticHelper;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=5, tags={DiagnosticTag.BRAINOVERLOAD, DiagnosticTag.SUSPICIOUS})
public class LatinAndCyrillicSymbolInWordDiagnostic
extends AbstractDiagnostic {
    private static final int MINIMAL_WORD_LEN = 2;
    private static final int MINIMAL_WORD_LEN_TWO_LANG = 4;
    private static final String DEFAULT_EXCLUDE_WORDS = "\u0427\u0442\u0435\u043d\u0438\u0435XML, \u0427\u0442\u0435\u043d\u0438\u0435JSON, \u0417\u0430\u043f\u0438\u0441\u044cXML, \u0417\u0430\u043f\u0438\u0441\u044cJSON, Com\u041e\u0431\u044a\u0435\u043a\u0442, \u0424\u0430\u0431\u0440\u0438\u043a\u0430XDTO, \u041e\u0431\u044a\u0435\u043a\u0442XDTO, \u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435FTP, HTTP\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435, HTTP\u0417\u0430\u043f\u0440\u043e\u0441, HTTP\u0421\u0435\u0440\u0432\u0438\u0441\u041e\u0442\u0432\u0435\u0442, SMS\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435, WS\u041f\u0440\u043e\u043a\u0441\u0438";
    private static final boolean DEFAULT_ALLOW_TRAILING_PARTS_IN_ANOTHER_LANG = true;
    private static final Pattern RU_LANG_PATTERN = CaseInsensitivePattern.compile((String)"[\u0430-\u044f\u0451]");
    private static final Pattern EN_LANG_PATTERN = CaseInsensitivePattern.compile((String)"[a-z]");
    private static final Pattern RU_EN_LANG_PATTERN = Pattern.compile("[A-Z][A-Za-z]+[A-Za-z1-9_]*[\u0410-\u042f\u0401][\u0410-\u042f\u0430-\u044f\u0401\u0451]+[\u0410-\u042f\u0430-\u044f1-9\u0401\u0451_]*|[\u0410-\u042f\u0401][\u0410-\u042f\u0430-\u044f\u0401\u0451]+[\u0410-\u042f\u0430-\u044f1-9\u0401\u0451_]*[A-Z][A-Za-z]+[A-Za-z1-9_]*");
    @DiagnosticParameter(type=String.class, defaultValue="\u0427\u0442\u0435\u043d\u0438\u0435XML, \u0427\u0442\u0435\u043d\u0438\u0435JSON, \u0417\u0430\u043f\u0438\u0441\u044cXML, \u0417\u0430\u043f\u0438\u0441\u044cJSON, Com\u041e\u0431\u044a\u0435\u043a\u0442, \u0424\u0430\u0431\u0440\u0438\u043a\u0430XDTO, \u041e\u0431\u044a\u0435\u043a\u0442XDTO, \u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435FTP, HTTP\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435, HTTP\u0417\u0430\u043f\u0440\u043e\u0441, HTTP\u0421\u0435\u0440\u0432\u0438\u0441\u041e\u0442\u0432\u0435\u0442, SMS\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435, WS\u041f\u0440\u043e\u043a\u0441\u0438")
    private Pattern excludeWords = LatinAndCyrillicSymbolInWordDiagnostic.createExcludeWordPattern("\u0427\u0442\u0435\u043d\u0438\u0435XML, \u0427\u0442\u0435\u043d\u0438\u0435JSON, \u0417\u0430\u043f\u0438\u0441\u044cXML, \u0417\u0430\u043f\u0438\u0441\u044cJSON, Com\u041e\u0431\u044a\u0435\u043a\u0442, \u0424\u0430\u0431\u0440\u0438\u043a\u0430XDTO, \u041e\u0431\u044a\u0435\u043a\u0442XDTO, \u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435FTP, HTTP\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435, HTTP\u0417\u0430\u043f\u0440\u043e\u0441, HTTP\u0421\u0435\u0440\u0432\u0438\u0441\u041e\u0442\u0432\u0435\u0442, SMS\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435, WS\u041f\u0440\u043e\u043a\u0441\u0438");
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean allowTrailingPartsInAnotherLanguage = true;

    private static Pattern createExcludeWordPattern(String words) {
        StringJoiner stringJoiner = new StringJoiner("|");
        for (String elem : words.split(",")) {
            stringJoiner.add(Pattern.quote(elem.trim()));
        }
        return CaseInsensitivePattern.compile((String)("(?:^" + stringJoiner + ")"));
    }

    @Override
    public void configure(Map<String, Object> configuration) {
        DiagnosticHelper.configureDiagnostic(this, configuration, "allowTrailingPartsInAnotherLanguage");
        this.excludeWords = LatinAndCyrillicSymbolInWordDiagnostic.createExcludeWordPattern((String)configuration.getOrDefault("excludeWords", DEFAULT_EXCLUDE_WORDS));
    }

    @Override
    protected void check() {
        this.check(36);
        this.check(27);
        this.check(22);
        this.check(23);
        this.check(8);
        this.checkLabel();
        this.checkParameters();
        this.checkLValue();
    }

    private void check(int ruleID) {
        this.checkTree(Trees.findAllRuleNodes((ParseTree)this.documentContext.getAst(), ruleID).stream());
    }

    private void checkLValue() {
        this.checkTree(Trees.findAllRuleNodes((ParseTree)this.documentContext.getAst(), 98).stream().filter(ctx -> ((BSLParser.LValueContext)ctx).IDENTIFIER() != null).map(ctx -> ((BSLParser.LValueContext)ctx).IDENTIFIER()));
    }

    private void checkParameters() {
        this.checkTree(Trees.findAllRuleNodes((ParseTree)this.documentContext.getAst(), 75).stream().filter(ctx -> ((BSLParser.ParamContext)ctx).IDENTIFIER() != null).map(ctx -> ((BSLParser.ParamContext)ctx).IDENTIFIER()));
    }

    private void checkLabel() {
        this.checkTree(Trees.findAllRuleNodes((ParseTree)this.documentContext.getAst(), 59).stream().filter(ctx -> ctx.getParent() instanceof BSLParser.GotoStatementContext));
    }

    private void checkTree(Stream<ParseTree> tree) {
        Stream<ParseTree> elements = tree.filter(ctx -> ctx.getText() != null && ctx.getText().length() >= 2).filter(ctx -> !this.excludeWords.matcher(ctx.getText()).matches()).filter(ctx -> RU_LANG_PATTERN.matcher(ctx.getText()).find() && EN_LANG_PATTERN.matcher(ctx.getText()).find());
        if (this.allowTrailingPartsInAnotherLanguage) {
            elements.filter(ctx -> ctx.getText().length() < 4 || !RU_EN_LANG_PATTERN.matcher(ctx.getText()).matches()).forEach(this.diagnosticStorage::addDiagnostic);
        } else {
            elements.forEach(this.diagnosticStorage::addDiagnostic);
        }
    }
}

