/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.MethodDescription;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=1, tags={DiagnosticTag.STANDARD, DiagnosticTag.BADPRACTICE})
public class LineLengthDiagnostic
extends AbstractDiagnostic {
    private static final int MAX_LINE_LENGTH = 120;
    private static final boolean CHECK_METHOD_DESCRIPTION = true;
    private int prevTokenType;
    @DiagnosticParameter(type=Integer.class, defaultValue="120")
    private int maxLineLength = 120;
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean checkMethodDescription = true;
    private final Map<Integer, List<Integer>> tokensInOneLine = new HashMap<Integer, List<Integer>>();

    @Override
    protected void check() {
        this.tokensInOneLine.clear();
        this.documentContext.getTokensFromDefaultChannel().forEach(token -> {
            if (this.mustBePutIn((Token)token)) {
                this.putInCollection((Token)token);
            }
            this.prevTokenType = token.getType();
        });
        if (this.checkMethodDescription) {
            this.documentContext.getComments().forEach(this::putInCollection);
        } else {
            List descriptionRanges = this.documentContext.getSymbolTree().getMethods().stream().map(MethodSymbol::getDescription).flatMap(Optional::stream).map(MethodDescription::getRange).collect(Collectors.toList());
            this.documentContext.getComments().stream().filter(token -> !LineLengthDiagnostic.descriptionContainToken(descriptionRanges, token)).forEach(this::putInCollection);
        }
        this.tokensInOneLine.forEach((key, value) -> {
            Integer maxCharPosition = value.stream().max(Integer::compareTo).orElse(0);
            if (maxCharPosition > this.maxLineLength) {
                this.diagnosticStorage.addDiagnostic(Ranges.create(key, 0, key, maxCharPosition), this.info.getMessage(maxCharPosition, this.maxLineLength));
            }
        });
    }

    private boolean mustBePutIn(Token token) {
        boolean isStringPart = token.getType() == 40 || token.getType() == 39;
        boolean prevIsStringPart = this.prevTokenType == 40 || this.prevTokenType == 39;
        return !isStringPart && (!prevIsStringPart || token.getType() != 9);
    }

    private void putInCollection(Token token) {
        List tokenList = this.tokensInOneLine.getOrDefault(token.getLine() - 1, new ArrayList());
        tokenList.add(token.getCharPositionInLine() + token.getText().length());
        this.tokensInOneLine.put(token.getLine() - 1, tokenList);
    }

    private static boolean descriptionContainToken(List<Range> descriptionRanges, Token token) {
        if (descriptionRanges.isEmpty()) {
            return false;
        }
        Range first = descriptionRanges.get(0);
        if (first.getStart().getLine() + 1 > token.getLine()) {
            return false;
        }
        if (first.getEnd().getLine() + 1 < token.getLine()) {
            descriptionRanges.remove(first);
            return LineLengthDiagnostic.descriptionContainToken(descriptionRanges, token);
        }
        return Ranges.containsRange(first, Ranges.create(token));
    }
}

