/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.ParameterDefinition;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceIndex;
import com.github._1c_syntax.bsl.languageserver.references.model.Reference;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.MAJOR, minutesToFix=1, tags={DiagnosticTag.ERROR})
public class MissedRequiredParameterDiagnostic
extends AbstractVisitorDiagnostic {
    private final ReferenceIndex referenceIndex;
    private final Map<Range, MethodCall> calls = new HashMap<Range, MethodCall>();

    public ParseTree visitFile(BSLParser.FileContext ctx) {
        super.visitFile(ctx);
        for (Reference reference : this.referenceIndex.getReferencesFrom(this.documentContext.getUri(), SymbolKind.Method)) {
            MethodCall call = this.calls.get(reference.getSelectionRange());
            if (call == null) continue;
            this.checkMethod((MethodSymbol)reference.getSymbol(), call);
        }
        return ctx;
    }

    public ParseTree visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        String methodName = ctx.methodName().IDENTIFIER().getText();
        if (this.documentContext.getSymbolTree().getMethodSymbol(methodName).isPresent()) {
            this.appendMethodCall(ctx.methodName().getStart(), ctx.doCall(), (BSLParserRuleContext)ctx);
        }
        return (ParseTree)super.visitGlobalMethodCall(ctx);
    }

    public ParseTree visitMethodCall(BSLParser.MethodCallContext ctx) {
        this.appendMethodCall(ctx.methodName().getStart(), ctx.doCall(), (BSLParserRuleContext)ctx);
        return (ParseTree)super.visitMethodCall(ctx);
    }

    private void appendMethodCall(Token methodName, BSLParser.DoCallContext doCallContext, BSLParserRuleContext node) {
        List parameters = doCallContext.callParamList().callParam();
        MethodCall methodCall = new MethodCall();
        methodCall.parameters = new Boolean[parameters.size()];
        for (int i = 0; i < methodCall.parameters.length; ++i) {
            methodCall.parameters[i] = ((BSLParser.CallParamContext)parameters.get(i)).expression() != null;
        }
        methodCall.range = Ranges.create((ParserRuleContext)node);
        this.calls.put(Ranges.create(methodName), methodCall);
    }

    private void checkMethod(MethodSymbol methodDefinition, MethodCall callInfo) {
        int callParametersCount = callInfo.parameters.length;
        ArrayList<String> missedParameters = new ArrayList<String>();
        for (int i = 0; i < methodDefinition.getParameters().size(); ++i) {
            ParameterDefinition methodParameter = methodDefinition.getParameters().get(i);
            if (methodParameter.isOptional() || callParametersCount > i && callInfo.parameters[i].booleanValue()) continue;
            missedParameters.add(methodParameter.getName());
        }
        if (!missedParameters.isEmpty()) {
            String message = this.info.getMessage(String.format("'%s'", String.join((CharSequence)"', '", missedParameters)));
            this.diagnosticStorage.addDiagnostic(callInfo.range, message);
        }
    }

    @ConstructorProperties(value={"referenceIndex"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MissedRequiredParameterDiagnostic(ReferenceIndex referenceIndex) {
        this.referenceIndex = referenceIndex;
    }

    private static class MethodCall {
        Boolean[] parameters;
        Range range;

        private MethodCall() {
        }
    }
}

