/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.mdclasses.CF;
import com.github._1c_syntax.bsl.mdo.CommonModule;
import com.github._1c_syntax.bsl.mdo.EventSubscription;
import com.github._1c_syntax.bsl.types.ConfigurationSource;
import com.github._1c_syntax.bsl.types.ModuleType;
import java.util.Optional;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.BLOCKER, minutesToFix=5, tags={DiagnosticTag.ERROR}, scope=DiagnosticScope.BSL, modules={ModuleType.SessionModule})
public class MissingEventSubscriptionHandlerDiagnostic
extends AbstractDiagnostic {
    private Range diagnosticRange;

    @Override
    protected void check() {
        CF configuration = this.documentContext.getServerContext().getConfiguration();
        if (configuration.getConfigurationSource() == ConfigurationSource.EMPTY) {
            return;
        }
        this.diagnosticRange = this.documentContext.getSymbolTree().getModule().getSelectionRange();
        if (Ranges.isEmpty(this.diagnosticRange)) {
            return;
        }
        configuration.getEventSubscriptions().forEach(eventSubs -> {
            if (eventSubs.getHandler().isEmpty()) {
                this.addDiagnostic((EventSubscription)eventSubs);
                return;
            }
            if (eventSubs.getHandler().getMethodName().isEmpty()) {
                this.addDiagnostic("incorrectHandler", (EventSubscription)eventSubs, eventSubs.getHandler().getMethodPath());
                return;
            }
            Optional module = configuration.findCommonModule(eventSubs.getHandler().getModuleName());
            if (module.isEmpty()) {
                this.addDiagnostic("missingModule", (EventSubscription)eventSubs, eventSubs.getHandler().getModuleName());
                return;
            }
            CommonModule commonModule = (CommonModule)module.get();
            if (!commonModule.isServer()) {
                this.addDiagnostic("shouldBeServer", (EventSubscription)eventSubs, eventSubs.getHandler().getModuleName());
            }
            this.checkMethod((EventSubscription)eventSubs, eventSubs.getHandler().getMethodName(), commonModule);
        });
    }

    private void checkMethod(EventSubscription eventSubs, String methodName, CommonModule commonModule) {
        this.documentContext.getServerContext().getDocument(commonModule.getMdoReference().getMdoRef(), ModuleType.CommonModule).ifPresent(commonModuleContext -> {
            Optional<MethodSymbol> method = commonModuleContext.getSymbolTree().getMethods().stream().filter(methodSymbol -> methodSymbol.getName().equalsIgnoreCase(methodName)).findFirst();
            if (method.isEmpty()) {
                this.addDiagnostic("missingMethod", eventSubs, commonModule.getName() + "." + methodName);
                return;
            }
            if (!method.get().isExport()) {
                this.addDiagnostic("nonExportMethod", eventSubs, commonModule.getName() + "." + methodName);
            }
        });
    }

    private void addDiagnostic(String messageString, EventSubscription eventSubs, String text) {
        this.diagnosticStorage.addDiagnostic(this.diagnosticRange, this.info.getResourceString(messageString, text, eventSubs.getName()));
    }

    private void addDiagnostic(EventSubscription eventSubs) {
        this.diagnosticStorage.addDiagnostic(this.diagnosticRange, this.info.getMessage(eventSubs.getName()));
    }
}

