/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.QuickFixProvider;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.providers.CodeActionProvider;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=2, tags={DiagnosticTag.STANDARD, DiagnosticTag.DESIGN})
public class OneStatementPerLineDiagnostic
extends AbstractVisitorDiagnostic
implements QuickFixProvider {
    private static final Pattern NEW_LINE_PATTERN = CaseInsensitivePattern.compile((String)"^(\\s+?)[^\\s]");
    private int previousLineNumber;
    private final List<BSLParser.StatementContext> statementsPerLine = new ArrayList<BSLParser.StatementContext>();

    private List<DiagnosticRelatedInformation> getRelatedInformation(BSLParser.StatementContext self) {
        ArrayList<DiagnosticRelatedInformation> relatedInformation = new ArrayList<DiagnosticRelatedInformation>();
        this.statementsPerLine.stream().filter(context -> !context.equals(self)).map(context -> RelatedInformation.create(this.documentContext.getUri(), Ranges.create((ParserRuleContext)context), "+1")).collect(Collectors.toCollection(() -> relatedInformation));
        return relatedInformation;
    }

    private void addDiagnostics() {
        if (!this.statementsPerLine.isEmpty()) {
            this.statementsPerLine.forEach(context -> this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)context, this.getRelatedInformation((BSLParser.StatementContext)context)));
            this.statementsPerLine.clear();
        }
    }

    public ParseTree visitStatement(BSLParser.StatementContext ctx) {
        int currentLine = ctx.getStart().getLine();
        if (currentLine == this.previousLineNumber) {
            this.statementsPerLine.add(ctx);
        } else {
            this.addDiagnostics();
        }
        if (ctx.preprocessor() != null || ctx.exception != null || ctx.getChildCount() == 1 && ctx.SEMICOLON() != null) {
            this.statementsPerLine.clear();
            return (ParseTree)super.visitStatement(ctx);
        }
        this.previousLineNumber = currentLine;
        return (ParseTree)super.visitStatement(ctx);
    }

    public ParseTree visitFile(BSLParser.FileContext ctx) {
        this.statementsPerLine.clear();
        super.visitFile(ctx);
        this.addDiagnostics();
        return ctx;
    }

    @Override
    public List<CodeAction> getQuickFixes(List<Diagnostic> diagnostics, CodeActionParams params, DocumentContext documentContext) {
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        diagnostics.forEach(diagnostic -> {
            Range range = diagnostic.getRange();
            Range startLineRange = Ranges.create(range.getStart().getLine(), 0, range.getStart().getLine(), range.getStart().getCharacter());
            Matcher matcher = NEW_LINE_PATTERN.matcher(documentContext.getText(startLineRange));
            String indent = "";
            if (matcher.find()) {
                indent = matcher.group(1);
            }
            TextEdit textEdit = new TextEdit(range, "\n" + indent + documentContext.getText(range));
            textEdits.add(textEdit);
        });
        return CodeActionProvider.createCodeActions(textEdits, this.info.getResourceString("quickFixMessage"), documentContext.getUri(), diagnostics);
    }
}

