/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.Symbol;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.SymbolKind;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, minutesToFix=1, tags={DiagnosticTag.STANDARD, DiagnosticTag.BRAINOVERLOAD, DiagnosticTag.BADPRACTICE})
public class PublicMethodsDescriptionDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern API_REGION_NAME = CaseInsensitivePattern.compile((String)"^(?:\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441|Public)$");
    private static final boolean DEFAULT_CHECK_ALL_REGION = false;
    @DiagnosticParameter(type=Boolean.class, defaultValue="false")
    private boolean checkAllRegion = false;

    public ParseTree visitSub(BSLParser.SubContext ctx) {
        this.documentContext.getSymbolTree().getMethodSymbol((BSLParserRuleContext)ctx).ifPresent(methodSymbol -> {
            if (methodSymbol.isExport() && methodSymbol.getDescription().isEmpty()) {
                if (this.checkAllRegion) {
                    this.diagnosticStorage.addDiagnostic(methodSymbol.getSubNameRange());
                } else {
                    methodSymbol.getRootParent(SymbolKind.Namespace).ifPresent(rootRegion -> {
                        if (PublicMethodsDescriptionDiagnostic.isAPIRegion(rootRegion)) {
                            this.diagnosticStorage.addDiagnostic(methodSymbol.getSubNameRange());
                        }
                    });
                }
            }
        });
        return ctx;
    }

    private static boolean isAPIRegion(Symbol symbol) {
        return API_REGION_NAME.matcher(symbol.getName()).matches();
    }
}

