/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractSDBLVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.bsl.parser.SDBLParser;
import com.github._1c_syntax.bsl.types.ConfigurationSource;
import com.github._1c_syntax.bsl.types.MDOType;
import java.util.Optional;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.BLOCKER, scope=DiagnosticScope.BSL, minutesToFix=5, tags={DiagnosticTag.SUSPICIOUS, DiagnosticTag.SQL})
public class QueryToMissingMetadataDiagnostic
extends AbstractSDBLVisitorDiagnostic {
    @Override
    public ParseTree visitQueryPackage(SDBLParser.QueryPackageContext ctx) {
        if (this.documentContext.getServerContext().getConfiguration().getConfigurationSource() == ConfigurationSource.EMPTY) {
            return ctx;
        }
        return super.visitQueryPackage(ctx);
    }

    public ParseTree visitMdo(SDBLParser.MdoContext mdo) {
        if (this.nonMdoExists(mdo.type.getText(), mdo.tableName.getText())) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)mdo, this.info.getMessage(mdo.getText()));
        }
        return (ParseTree)super.visitMdo(mdo);
    }

    private boolean nonMdoExists(String mdoType, String mdoName) {
        return this.getMdo(mdoType, mdoName).isEmpty();
    }

    private Optional<MD> getMdo(String mdoTypeName, String mdoName) {
        return MDOType.fromValue((String)mdoTypeName).flatMap(mdoType -> this.documentContext.getServerContext().getConfiguration().findChild(mdo -> mdo.getMdoType() == mdoType && mdoName.equalsIgnoreCase(mdo.getName())));
    }
}

