/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractSDBLVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.mdclasses.CF;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.mdo.TabularSectionOwner;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.bsl.parser.SDBLParser;
import com.github._1c_syntax.bsl.types.ConfigurationSource;
import com.github._1c_syntax.bsl.types.MDOType;
import com.github._1c_syntax.bsl.types.MdoReference;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, scope=DiagnosticScope.BSL, minutesToFix=5, tags={DiagnosticTag.SQL, DiagnosticTag.PERFORMANCE})
public class RefOveruseDiagnostic
extends AbstractSDBLVisitorDiagnostic {
    private static final Pattern REF_PATTERN = CaseInsensitivePattern.compile((String)"\u0421\u0441\u044b\u043b\u043a\u0430|Reference");
    private static final int COUNT_OF_TABLE_DOT_REF = 3;
    private static final int LAST_INDEX_OF_TABLE_DOT_REF = 2;
    private static final int COUNT_OF_TABLE_DOT_REF_DOT_REF = 5;
    private static final Set<Integer> RULE_COLUMNS = Set.of(Integer.valueOf(25), Integer.valueOf(6));
    private static final Set<Integer> METADATA_TYPES = Set.of(121, 123, 128, 134, 127, 133, 131, 135, 129, 130, 126, 124, 125, 120, 119, 122, 136, 132);
    private static final Collection<Integer> EXCLUDED_COLUMNS_ROOT = Set.of(Integer.valueOf(16), Integer.valueOf(6));
    public static final List<String> SPECIAL_LIST_FOR_DATA_SOURCE = List.of("");
    private Map<String, List<String>> dataSourceWithTabularSectionNames = Collections.emptyMap();
    private Map<String, List<String>> prevDataSourceWithTabularSectionNames = Collections.emptyMap();
    @Nullable
    private Range prevQueryRange;

    @Override
    public ParseTree visitQueryPackage(SDBLParser.QueryPackageContext ctx) {
        ParseTree result = super.visitQueryPackage(ctx);
        this.prevQueryRange = null;
        this.prevDataSourceWithTabularSectionNames = Collections.emptyMap();
        this.dataSourceWithTabularSectionNames = Collections.emptyMap();
        return result;
    }

    public ParseTree visitQuery(SDBLParser.QueryContext ctx) {
        this.checkQuery(ctx).forEach(this.diagnosticStorage::addDiagnostic);
        return (ParseTree)super.visitQuery(ctx);
    }

    private Stream<SDBLParser.ColumnContext> checkQuery(SDBLParser.QueryContext ctx) {
        List<SDBLParser.ColumnContext> columns = Trees.findAllTopLevelDescendantNodes((ParserRuleContext)ctx, RULE_COLUMNS).stream().filter(parserRuleContext -> parserRuleContext.getRuleIndex() == 25).filter(parserRuleContext -> Trees.getRootParent((BSLParserRuleContext)parserRuleContext, EXCLUDED_COLUMNS_ROOT).getRuleIndex() == 6).map(SDBLParser.ColumnContext.class::cast).collect(Collectors.toList());
        if (columns.isEmpty()) {
            return Stream.empty();
        }
        this.dataSourceWithTabularSectionNames = this.dataSourcesWithTabularSection(ctx);
        if (this.dataSourceWithTabularSectionNames.isEmpty()) {
            return RefOveruseDiagnostic.getSimpleOverused(columns);
        }
        return this.getOverused(columns);
    }

    private Map<String, List<String>> dataSourcesWithTabularSection(SDBLParser.QueryContext ctx) {
        Map<String, List<String>> result;
        Map<String, List<String>> newResult = this.calcDataSourceWithTabularSectionNames(RefOveruseDiagnostic.findAllDataSourceWithoutInnerQueries(ctx));
        Range queryRange = Ranges.create((ParserRuleContext)ctx);
        if (this.prevQueryRange == null || !Ranges.containsRange(this.prevQueryRange, queryRange)) {
            result = newResult;
            this.prevDataSourceWithTabularSectionNames = result;
            this.prevQueryRange = queryRange;
        } else {
            result = new HashMap<String, List<String>>(newResult);
            result.putAll(this.prevDataSourceWithTabularSectionNames);
        }
        return result;
    }

    private Map<String, List<String>> calcDataSourceWithTabularSectionNames(Stream<? extends SDBLParser.DataSourceContext> dataSources) {
        return dataSources.map(dataSourceContext -> new TabularSectionTable(RefOveruseDiagnostic.getTableNameOrAlias(dataSourceContext), this.getTabularSectionNames((SDBLParser.DataSourceContext)dataSourceContext))).collect(Collectors.toMap(TabularSectionTable::tableNameOrAlias, TabularSectionTable::tabularSectionNames, (existing, replacement) -> existing));
    }

    private static Stream<? extends SDBLParser.DataSourceContext> findAllDataSourceWithoutInnerQueries(SDBLParser.QueryContext ctx) {
        if (ctx.from == null) {
            return Stream.empty();
        }
        return Stream.concat(ctx.from.dataSource().stream(), ctx.from.dataSource().stream().flatMap(dataSourceContext -> RefOveruseDiagnostic.getInnerDataSource(dataSourceContext).stream()));
    }

    private static Collection<SDBLParser.DataSourceContext> getInnerDataSource(SDBLParser.DataSourceContext dataSourceContext) {
        ArrayList<SDBLParser.DataSourceContext> result = new ArrayList<SDBLParser.DataSourceContext>();
        Optional.ofNullable(dataSourceContext.dataSource()).map(RefOveruseDiagnostic::getInnerDataSource).ifPresent(result::addAll);
        List<SDBLParser.DataSourceContext> joinDataSources = dataSourceContext.joinPart().stream().map(SDBLParser.JoinPartContext::dataSource).filter(Objects::nonNull).toList();
        result.addAll(joinDataSources);
        List dataSourcesFromJoins = joinDataSources.stream().flatMap(dataSourceContext1 -> RefOveruseDiagnostic.getInnerDataSource(dataSourceContext1).stream()).toList();
        result.addAll(dataSourcesFromJoins);
        return result;
    }

    private static String getTableNameOrAlias(SDBLParser.DataSourceContext dataSource) {
        Optional<SDBLParser.DataSourceContext> value = Optional.of(dataSource);
        return value.map(SDBLParser.DataSourceContext::alias).map(alias -> alias.name).or(() -> value.map(SDBLParser.DataSourceContext::table).map(tableContext -> tableContext.tableName)).or(() -> value.map(SDBLParser.DataSourceContext::parameterTable).map(tableContext -> tableContext.parameter())).map(ParseTree::getText).orElse("");
    }

    private List<String> getTabularSectionNames(SDBLParser.DataSourceContext dataSourceContext) {
        SDBLParser.TableContext table = dataSourceContext.table();
        if (table == null) {
            return RefOveruseDiagnostic.getSpecialListForDataSource(dataSourceContext.virtualTable() != null);
        }
        SDBLParser.MdoContext mdo = dataSourceContext.table().mdo();
        if (mdo == null) {
            return RefOveruseDiagnostic.getSpecialListForDataSource(table.tableName != null);
        }
        if (table.objectTableName != null) {
            return SPECIAL_LIST_FOR_DATA_SOURCE;
        }
        return this.getTabularSectionNames(mdo);
    }

    private static List<String> getSpecialListForDataSource(boolean useSpecialName) {
        if (useSpecialName) {
            return SPECIAL_LIST_FOR_DATA_SOURCE;
        }
        return Collections.emptyList();
    }

    private List<String> getTabularSectionNames(SDBLParser.MdoContext mdo) {
        CF configuration = this.documentContext.getServerContext().getConfiguration();
        if (configuration.getConfigurationSource() == ConfigurationSource.EMPTY) {
            return Collections.emptyList();
        }
        return MDOType.fromValue((String)mdo.type.getText()).stream().map(mdoTypeTabular -> MdoReference.create((MDOType)mdoTypeTabular, (String)mdo.tableName.getText())).map(arg_0 -> ((CF)configuration).findChild(arg_0)).filter(Optional::isPresent).map(Optional::get).filter(TabularSectionOwner.class::isInstance).map(TabularSectionOwner.class::cast).flatMap(RefOveruseDiagnostic::getTabularSectionNames).collect(Collectors.toList());
    }

    private static Stream<String> getTabularSectionNames(TabularSectionOwner tabularSectionOwner) {
        return tabularSectionOwner.getTabularSections().stream().map(MD::getName);
    }

    private static Stream<SDBLParser.ColumnContext> getSimpleOverused(List<SDBLParser.ColumnContext> columnsCollection) {
        return columnsCollection.stream().filter(columnNode -> columnNode.getChildCount() > 3).filter(column -> REF_PATTERN.matcher(column.getChild(column.getChildCount() - 1).getText()).matches());
    }

    private Stream<SDBLParser.ColumnContext> getOverused(List<SDBLParser.ColumnContext> columnsCollection) {
        return columnsCollection.stream().map(SDBLParser.ColumnContext.class::cast).filter(column -> column.getChildCount() >= 3).filter(this::isOveruse);
    }

    private boolean isOveruse(SDBLParser.ColumnContext ctx) {
        int lastIndex;
        List<ParseTree> children = RefOveruseDiagnostic.extractFirstMetadataTypeName(ctx);
        int refIndex = RefOveruseDiagnostic.findLastRef(children);
        if (refIndex == (lastIndex = children.size() - 1)) {
            String penultimateIdentifierName = children.get(lastIndex - 2).getText();
            return this.dataSourceWithTabularSectionNames.get(penultimateIdentifierName) == null;
        }
        if (refIndex < 2) {
            return false;
        }
        if (refIndex > 2) {
            return true;
        }
        String tabName = children.get(0).getText();
        return this.dataSourceWithTabularSectionNames.getOrDefault(tabName, Collections.emptyList()).isEmpty();
    }

    private static int findLastRef(List<ParseTree> children) {
        for (int i = children.size() - 1; i >= 0; --i) {
            ParseTree child = children.get(i);
            String childText = child.getText();
            if (!REF_PATTERN.matcher(childText).matches()) continue;
            return i;
        }
        return -1;
    }

    private static List<ParseTree> extractFirstMetadataTypeName(SDBLParser.ColumnContext ctx) {
        SDBLParser.IdentifierContext mdoName = ctx.mdoName;
        List children = ctx.children;
        if (mdoName == null || children.size() < 5 || !METADATA_TYPES.contains(mdoName.getStart().getType())) {
            return children;
        }
        return children.subList(1, children.size() - 1);
    }

    private record TabularSectionTable(String tableNameOrAlias, List<String> tabularSectionNames) {
    }
}

