/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractSDBLVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.bsl.parser.SDBLParser;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=5, tags={DiagnosticTag.STANDARD, DiagnosticTag.SQL, DiagnosticTag.SUSPICIOUS}, scope=DiagnosticScope.BSL)
public class SelectTopWithoutOrderByDiagnostic
extends AbstractSDBLVisitorDiagnostic {
    private static final boolean SKIP_SELECT_TOP_ONE = true;
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean skipSelectTopOne = true;

    public ParseTree visitSubquery(SDBLParser.SubqueryContext ctx) {
        if (!ctx.union().isEmpty()) {
            this.checkQuery(ctx.query(), false);
            ctx.union().forEach(unionCtx -> this.checkQuery(unionCtx.query(), false));
        } else if (!Trees.nodeContains((ParseTree)ctx.getParent(), 20)) {
            this.checkQuery(ctx.query(), this.skipSelectTopOne);
        }
        return (ParseTree)super.visitSubquery(ctx);
    }

    private void checkQuery(@Nullable SDBLParser.QueryContext ctx, boolean canTopOne) {
        boolean allowedTopNumber;
        if (ctx == null) {
            return;
        }
        SDBLParser.LimitationsContext limitations = ctx.limitations();
        if (limitations == null || limitations.top() == null) {
            return;
        }
        SDBLParser.TopContext topCtx = ctx.limitations().top();
        if (topCtx.DECIMAL() == null) {
            return;
        }
        String topLimit = topCtx.DECIMAL().getText();
        boolean bl = allowedTopNumber = "1".equals(topLimit) || "0".equals(topLimit);
        if (!allowedTopNumber || !canTopOne && ctx.where == null) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)topCtx);
        }
    }
}

