/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

@DiagnosticMetadata(type=DiagnosticType.SECURITY_HOTSPOT, severity=DiagnosticSeverity.CRITICAL, minutesToFix=15, tags={DiagnosticTag.STANDARD, DiagnosticTag.DESIGN})
public class UsingExternalCodeToolsDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern externalCodeToolsName = CaseInsensitivePattern.compile((String)"^(\u0412\u043d\u0435\u0448\u043d\u0438\u0435\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438|ExternalDataProcessors|\u0412\u043d\u0435\u0448\u043d\u0438\u0435\u041e\u0442\u0447\u0435\u0442\u044b|ExternalReports|\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438|ConfigurationExtensions)");
    private static final Pattern externalCodeToolsMethodsName = CaseInsensitivePattern.compile((String)"^(\u0421\u043e\u0437\u0434\u0430\u0442\u044c|Create|\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c|Connect)");

    public ParseTree visitCallStatement(BSLParser.CallStatementContext ctx) {
        if (ctx.globalMethodCall() == null) {
            this.checkUseExternalCodeTools((BSLParserRuleContext)ctx, ctx.IDENTIFIER());
        }
        return (ParseTree)super.visitCallStatement(ctx);
    }

    public ParseTree visitComplexIdentifier(BSLParser.ComplexIdentifierContext ctx) {
        this.checkUseExternalCodeTools((BSLParserRuleContext)ctx, ctx.IDENTIFIER());
        return (ParseTree)super.visitComplexIdentifier(ctx);
    }

    private void checkUseExternalCodeTools(BSLParserRuleContext ctx, TerminalNode identifier) {
        if (identifier != null && externalCodeToolsName.matcher(identifier.getText()).matches() && Trees.findAllRuleNodes((ParseTree)ctx, 92).stream().anyMatch(child -> externalCodeToolsMethodsName.matcher(((BSLParser.MethodCallContext)child).getStart().getText()).matches())) {
            this.diagnosticStorage.addDiagnostic(ctx);
        }
    }
}

