/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.hover;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.VariableSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.variable.VariableDescription;
import com.github._1c_syntax.bsl.languageserver.hover.MarkupContentBuilder;
import com.github._1c_syntax.bsl.languageserver.utils.MdoRefBuilder;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.StringJoiner;
import lombok.Generated;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SymbolKind;
import org.springframework.stereotype.Component;

@Component
public class VariableSymbolMarkupContentBuilder
implements MarkupContentBuilder<VariableSymbol> {
    private static final String VARIABLE_KEY = "var";
    private static final String EXPORT_KEY = "export";
    private final LanguageServerConfiguration configuration;

    @Override
    public MarkupContent getContent(VariableSymbol symbol) {
        StringJoiner markupBuilder = new StringJoiner("\n");
        String signature = this.getSignature(symbol);
        VariableSymbolMarkupContentBuilder.addSectionIfNotEmpty(markupBuilder, signature);
        String location = VariableSymbolMarkupContentBuilder.getLocation(symbol);
        VariableSymbolMarkupContentBuilder.addSectionIfNotEmpty(markupBuilder, location);
        symbol.getDescription().map(VariableDescription::getPurposeDescription).ifPresent(description -> VariableSymbolMarkupContentBuilder.addSectionIfNotEmpty(markupBuilder, description));
        symbol.getDescription().flatMap(VariableDescription::getTrailingDescription).map(VariableDescription::getPurposeDescription).ifPresent(trailingDescription -> VariableSymbolMarkupContentBuilder.addSectionIfNotEmpty(markupBuilder, trailingDescription));
        String content = markupBuilder.toString();
        return new MarkupContent("markdown", content);
    }

    @Override
    public SymbolKind getSymbolKind() {
        return SymbolKind.Variable;
    }

    private String getSignature(VariableSymbol symbol) {
        String signatureTemplate = "```bsl\n%s %s%s\n```";
        String varKey = this.getResourceString(VARIABLE_KEY);
        String name = symbol.getName();
        String export = symbol.isExport() ? " " + this.getResourceString(EXPORT_KEY) : "";
        return String.format(signatureTemplate, varKey, name, export);
    }

    private static String getLocation(VariableSymbol symbol) {
        DocumentContext documentContext = symbol.getOwner();
        Position startPosition = symbol.getSelectionRange().getStart();
        Object mdoRef = MdoRefBuilder.getMdoRef(symbol.getOwner());
        String parentPostfix = symbol.getRootParent(SymbolKind.Method).map(sourceDefinedSymbol -> "." + sourceDefinedSymbol.getName()).orElse("");
        mdoRef = (String)mdoRef + parentPostfix;
        return String.format("[%s](%s#%d)", mdoRef, documentContext.getUri(), startPosition.getLine() + 1);
    }

    private static void addSectionIfNotEmpty(StringJoiner markupBuilder, String newContent) {
        if (!newContent.isEmpty()) {
            markupBuilder.add(newContent);
            markupBuilder.add("");
            markupBuilder.add("---");
        }
    }

    private String getResourceString(String key) {
        return Resources.getResourceString(this.configuration.getLanguage(), this.getClass(), key);
    }

    @ConstructorProperties(value={"configuration"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public VariableSymbolMarkupContentBuilder(LanguageServerConfiguration configuration) {
        this.configuration = configuration;
    }
}

