/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.github._1c_syntax.bsl.languageserver.color.ColorInformationSupplier;
import com.github._1c_syntax.bsl.languageserver.color.ColorPresentationSupplier;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.ColorPresentation;
import org.eclipse.lsp4j.ColorPresentationParams;
import org.springframework.stereotype.Component;

@Component
public class ColorProvider {
    private final List<ColorInformationSupplier> colorInformationSuppliers;
    private final List<ColorPresentationSupplier> colorPresentationSuppliers;

    public List<ColorInformation> getDocumentColor(DocumentContext documentContext) {
        return this.colorInformationSuppliers.stream().map(colorInformationSupplier -> colorInformationSupplier.getColorInformation(documentContext)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<ColorPresentation> getColorPresentation(DocumentContext documentContext, ColorPresentationParams params) {
        return this.colorPresentationSuppliers.stream().map(colorPresentationSupplier -> colorPresentationSupplier.getColorPresentation(documentContext, params)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"colorInformationSuppliers", "colorPresentationSuppliers"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ColorProvider(List<ColorInformationSupplier> colorInformationSuppliers, List<ColorPresentationSupplier> colorPresentationSuppliers) {
        this.colorInformationSuppliers = colorInformationSuppliers;
        this.colorPresentationSuppliers = colorPresentationSuppliers;
    }
}

