/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceResolver;
import com.github._1c_syntax.bsl.languageserver.references.model.Reference;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.springframework.stereotype.Component;

@Component
public class DefinitionProvider {
    private final ReferenceResolver referenceResolver;

    public List<LocationLink> getDefinition(DocumentContext documentContext, DefinitionParams params) {
        Position position = params.getPosition();
        return this.referenceResolver.findReference(documentContext.getUri(), position).filter(Reference::isSourceDefinedSymbolReference).map(DefinitionProvider::toLocationLink).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    private static LocationLink toLocationLink(Reference reference) {
        SourceDefinedSymbol symbol = (SourceDefinedSymbol)reference.getSymbol();
        return new LocationLink(symbol.getOwner().getUri().toString(), symbol.getRange(), symbol.getSelectionRange(), reference.getSelectionRange());
    }

    @ConstructorProperties(value={"referenceResolver"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DefinitionProvider(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }
}

