/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.references;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.events.DocumentContextContentChangedEvent;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.VariableSymbol;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceIndex;
import com.github._1c_syntax.bsl.languageserver.utils.MdoRefBuilder;
import com.github._1c_syntax.bsl.languageserver.utils.Methods;
import com.github._1c_syntax.bsl.languageserver.utils.Modules;
import com.github._1c_syntax.bsl.languageserver.utils.NotifyDescription;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Strings;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.mdclasses.CF;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserBaseVisitor;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.bsl.types.ModuleType;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ReferenceIndexFiller {
    private static final Set<ModuleType> DEFAULT_MODULE_TYPES = EnumSet.of(ModuleType.ManagerModule, ModuleType.CommonModule, ModuleType.UNKNOWN);
    private final ReferenceIndex index;

    @EventListener
    public void handleEvent(DocumentContextContentChangedEvent event) {
        DocumentContext documentContext = event.getSource();
        if (documentContext.isComputedDataFrozen()) {
            return;
        }
        this.fill(documentContext);
    }

    public void fill(DocumentContext documentContext) {
        this.index.clearReferences(documentContext.getUri());
        BSLParser.FileContext documentContextAst = documentContext.getAst();
        new MethodSymbolReferenceIndexFinder(documentContext).visitFile(documentContextAst);
        new VariableSymbolReferenceIndexFinder(documentContext).visitFile(documentContextAst);
    }

    @ConstructorProperties(value={"index"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ReferenceIndexFiller(ReferenceIndex index) {
        this.index = index;
    }

    private class MethodSymbolReferenceIndexFinder
    extends BSLParserBaseVisitor<BSLParserRuleContext> {
        private final DocumentContext documentContext;
        private Set<String> commonModuleMdoRefFromSubParams = Collections.emptySet();

        public BSLParserRuleContext visitProcDeclaration(BSLParser.ProcDeclarationContext ctx) {
            this.commonModuleMdoRefFromSubParams = this.calcParams(ctx.paramList());
            return (BSLParserRuleContext)super.visitProcDeclaration(ctx);
        }

        public BSLParserRuleContext visitFuncDeclaration(BSLParser.FuncDeclarationContext ctx) {
            this.commonModuleMdoRefFromSubParams = this.calcParams(ctx.paramList());
            return (BSLParserRuleContext)super.visitFuncDeclaration(ctx);
        }

        public BSLParserRuleContext visitCallStatement(BSLParser.CallStatementContext ctx) {
            if (ctx.globalMethodCall() != null) {
                return (BSLParserRuleContext)super.visitCallStatement(ctx);
            }
            String mdoRef = MdoRefBuilder.getMdoRef(this.documentContext, ctx);
            if (mdoRef.isEmpty()) {
                return (BSLParserRuleContext)super.visitCallStatement(ctx);
            }
            Methods.getMethodName(ctx).ifPresent(methodName -> this.checkCall(mdoRef, (Token)methodName));
            return (BSLParserRuleContext)super.visitCallStatement(ctx);
        }

        public BSLParserRuleContext visitComplexIdentifier(BSLParser.ComplexIdentifierContext ctx) {
            String mdoRef = MdoRefBuilder.getMdoRef(this.documentContext, ctx);
            if (mdoRef.isEmpty()) {
                return (BSLParserRuleContext)super.visitComplexIdentifier(ctx);
            }
            Methods.getMethodName(ctx).ifPresent(methodName -> this.checkCall(mdoRef, (Token)methodName));
            return (BSLParserRuleContext)super.visitComplexIdentifier(ctx);
        }

        public BSLParserRuleContext visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
            String mdoRef = MdoRefBuilder.getMdoRef(this.documentContext);
            ModuleType moduleType = this.documentContext.getModuleType();
            Token methodName = ctx.methodName().getStart();
            String methodNameText = methodName.getText();
            this.documentContext.getSymbolTree().getMethodSymbol(methodNameText).ifPresent(methodSymbol -> this.addMethodCall(mdoRef, moduleType, methodNameText, Ranges.create(methodName)));
            return (BSLParserRuleContext)super.visitGlobalMethodCall(ctx);
        }

        public BSLParserRuleContext visitNewExpression(BSLParser.NewExpressionContext ctx) {
            if (NotifyDescription.isNotifyDescription(ctx)) {
                BSLParser.DoCallContext doCallContext = ctx.doCall();
                if (doCallContext == null) {
                    return (BSLParserRuleContext)super.visitNewExpression(ctx);
                }
                List callParamList = doCallContext.callParamList().callParam();
                if (NotifyDescription.notifyDescriptionContainsHandler(callParamList)) {
                    this.addCallbackMethodCall((BSLParser.CallParamContext)callParamList.get(0), this.getModule((BSLParser.CallParamContext)callParamList.get(1)));
                }
                if (NotifyDescription.notifyDescriptionContainsErrorHandler(callParamList)) {
                    this.addCallbackMethodCall((BSLParser.CallParamContext)callParamList.get(3), this.getModule((BSLParser.CallParamContext)callParamList.get(4)));
                }
                return (BSLParserRuleContext)super.visitNewExpression(ctx);
            }
            return (BSLParserRuleContext)super.visitNewExpression(ctx);
        }

        public BSLParserRuleContext visitLValue(BSLParser.LValueContext ctx) {
            List modifiers;
            String mdoRef;
            TerminalNode identifier = ctx.IDENTIFIER();
            if (identifier != null && !(mdoRef = MdoRefBuilder.getMdoRef(this.documentContext, identifier, modifiers = Optional.ofNullable(ctx.acceptor()).map(BSLParser.AcceptorContext::modifier).orElseGet(Collections::emptyList))).isEmpty()) {
                Methods.getMethodName(ctx).ifPresent(methodName -> this.checkCall(mdoRef, (Token)methodName));
            }
            return (BSLParserRuleContext)super.visitLValue(ctx);
        }

        private void checkCall(String mdoRef, Token methodName) {
            String methodNameText = Strings.trimQuotes(methodName.getText());
            CF configuration = this.documentContext.getServerContext().getConfiguration();
            Map modules = configuration.mdoModuleTypes(mdoRef);
            for (ModuleType moduleType : modules.keySet()) {
                if (!DEFAULT_MODULE_TYPES.contains(moduleType) || moduleType == ModuleType.CommonModule && this.commonModuleMdoRefFromSubParams.contains(mdoRef)) continue;
                this.addMethodCall(mdoRef, moduleType, methodNameText, Ranges.create(methodName));
            }
        }

        private void addMethodCall(String mdoRef, ModuleType moduleType, String methodName, Range range) {
            ReferenceIndexFiller.this.index.addMethodCall(this.documentContext.getUri(), mdoRef, moduleType, methodName, range);
        }

        private void addCallbackMethodCall(BSLParser.CallParamContext methodName, String mdoRef) {
            if (mdoRef.isEmpty()) {
                return;
            }
            Methods.getMethodName(methodName).ifPresent(methodNameToken -> {
                if (!mdoRef.equals(MdoRefBuilder.getMdoRef(this.documentContext))) {
                    this.checkCall(mdoRef, (Token)methodNameToken);
                }
                this.addMethodCall(mdoRef, this.documentContext.getModuleType(), Strings.trimQuotes(methodName.getText()), Ranges.create((ParserRuleContext)methodName));
            });
        }

        private String getModule(BSLParser.CallParamContext callParamContext) {
            Optional<BSLParser.ComplexIdentifierContext> complexIdentifierContext1 = NotifyDescription.getFirstMember(callParamContext).map(BSLParser.MemberContext::complexIdentifier).filter(complexIdentifierContext -> complexIdentifierContext.IDENTIFIER() != null).filter(complexIdentifierContext -> complexIdentifierContext.modifier().isEmpty());
            if (complexIdentifierContext1.isEmpty()) {
                return "";
            }
            return complexIdentifierContext1.filter(Predicate.not(Modules::isThisObject)).map(complexIdentifier -> MdoRefBuilder.getMdoRef(this.documentContext, complexIdentifier)).orElse(MdoRefBuilder.getMdoRef(this.documentContext));
        }

        private Set<String> calcParams(@Nullable BSLParser.ParamListContext paramList) {
            if (paramList == null) {
                return Collections.emptySet();
            }
            CF configuration = this.documentContext.getServerContext().getConfiguration();
            return paramList.param().stream().map(BSLParser.ParamContext::IDENTIFIER).filter(Objects::nonNull).map(ParseTree::getText).map(arg_0 -> ((CF)configuration).findCommonModule(arg_0)).filter(Optional::isPresent).flatMap(Optional::stream).map(mdCommonModule -> mdCommonModule.getMdoReference().getMdoRef()).collect(Collectors.toSet());
        }

        @ConstructorProperties(value={"documentContext"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MethodSymbolReferenceIndexFinder(DocumentContext documentContext) {
            this.documentContext = documentContext;
        }
    }

    private class VariableSymbolReferenceIndexFinder
    extends BSLParserBaseVisitor<BSLParserRuleContext> {
        private final DocumentContext documentContext;
        private SourceDefinedSymbol currentScope;

        public BSLParserRuleContext visitModuleVarDeclaration(BSLParser.ModuleVarDeclarationContext ctx) {
            this.findVariableSymbol(ctx.var_name().getText()).ifPresent(s -> {
                if (this.notVariableInitialization(ctx, (VariableSymbol)s)) {
                    this.addVariableUsage(s.getRootParent(SymbolKind.Method), ctx.var_name().getText(), Ranges.create((ParserRuleContext)ctx.var_name()), false);
                }
            });
            return ctx;
        }

        public BSLParserRuleContext visitSub(BSLParser.SubContext ctx) {
            this.currentScope = this.documentContext.getSymbolTree().getModule();
            if (!Trees.nodeContainsErrors((ParseTree)ctx)) {
                this.documentContext.getSymbolTree().getMethodSymbol((BSLParserRuleContext)ctx).ifPresent(scope -> {
                    this.currentScope = scope;
                });
            }
            BSLParserRuleContext result = (BSLParserRuleContext)super.visitSub(ctx);
            this.currentScope = this.documentContext.getSymbolTree().getModule();
            return result;
        }

        public BSLParserRuleContext visitLValue(BSLParser.LValueContext ctx) {
            if (ctx.IDENTIFIER() == null) {
                return (BSLParserRuleContext)super.visitLValue(ctx);
            }
            this.findVariableSymbol(ctx.IDENTIFIER().getText()).ifPresent(s -> {
                if (this.notVariableInitialization(ctx, (VariableSymbol)s)) {
                    this.addVariableUsage(s.getRootParent(SymbolKind.Method), ctx.IDENTIFIER().getText(), Ranges.create(ctx.IDENTIFIER()), ctx.acceptor() != null);
                }
            });
            return (BSLParserRuleContext)super.visitLValue(ctx);
        }

        public BSLParserRuleContext visitCallStatement(BSLParser.CallStatementContext ctx) {
            if (ctx.IDENTIFIER() == null) {
                return (BSLParserRuleContext)super.visitCallStatement(ctx);
            }
            String variableName = ctx.IDENTIFIER().getText();
            this.findVariableSymbol(variableName).ifPresent(s -> this.addVariableUsage(s.getRootParent(SymbolKind.Method), variableName, Ranges.create(ctx.IDENTIFIER()), true));
            return (BSLParserRuleContext)super.visitCallStatement(ctx);
        }

        public BSLParserRuleContext visitComplexIdentifier(BSLParser.ComplexIdentifierContext ctx) {
            if (ctx.IDENTIFIER() == null) {
                return (BSLParserRuleContext)super.visitComplexIdentifier(ctx);
            }
            String variableName = ctx.IDENTIFIER().getText();
            this.findVariableSymbol(variableName).ifPresent(s -> this.addVariableUsage(s.getRootParent(SymbolKind.Method), variableName, Ranges.create(ctx.IDENTIFIER()), true));
            return (BSLParserRuleContext)super.visitComplexIdentifier(ctx);
        }

        public BSLParserRuleContext visitForStatement(BSLParser.ForStatementContext ctx) {
            if (ctx.IDENTIFIER() == null) {
                return (BSLParserRuleContext)super.visitForStatement(ctx);
            }
            this.findVariableSymbol(ctx.IDENTIFIER().getText()).ifPresent(s -> {
                if (this.notVariableInitialization(ctx, (VariableSymbol)s)) {
                    this.addVariableUsage(s.getRootParent(SymbolKind.Method), ctx.IDENTIFIER().getText(), Ranges.create(ctx.IDENTIFIER()), false);
                }
            });
            return (BSLParserRuleContext)super.visitForStatement(ctx);
        }

        public BSLParserRuleContext visitForEachStatement(BSLParser.ForEachStatementContext ctx) {
            if (ctx.IDENTIFIER() == null) {
                return (BSLParserRuleContext)super.visitForEachStatement(ctx);
            }
            this.findVariableSymbol(ctx.IDENTIFIER().getText()).ifPresent(s -> {
                if (this.notVariableInitialization(ctx, (VariableSymbol)s)) {
                    this.addVariableUsage(s.getRootParent(SymbolKind.Method), ctx.IDENTIFIER().getText(), Ranges.create(ctx.IDENTIFIER()), false);
                }
            });
            return (BSLParserRuleContext)super.visitForEachStatement(ctx);
        }

        private Optional<VariableSymbol> findVariableSymbol(String variableName) {
            Optional<VariableSymbol> variableSymbol = this.documentContext.getSymbolTree().getVariableSymbol(variableName, this.currentScope);
            if (variableSymbol.isPresent()) {
                return variableSymbol;
            }
            return this.documentContext.getSymbolTree().getVariableSymbol(variableName, this.documentContext.getSymbolTree().getModule());
        }

        private boolean notVariableInitialization(BSLParser.LValueContext ctx, VariableSymbol variableSymbol) {
            return !Ranges.containsRange(variableSymbol.getRange(), Ranges.create((ParserRuleContext)ctx));
        }

        private boolean notVariableInitialization(BSLParser.ModuleVarDeclarationContext ctx, VariableSymbol variableSymbol) {
            return !Ranges.containsRange(variableSymbol.getRange(), Ranges.create((ParserRuleContext)ctx));
        }

        private boolean notVariableInitialization(BSLParser.ForStatementContext ctx, VariableSymbol variableSymbol) {
            return !Ranges.containsRange(variableSymbol.getRange(), Ranges.create(ctx.IDENTIFIER()));
        }

        private boolean notVariableInitialization(BSLParser.ForEachStatementContext ctx, VariableSymbol variableSymbol) {
            return !Ranges.containsRange(variableSymbol.getRange(), Ranges.create(ctx.IDENTIFIER()));
        }

        private void addVariableUsage(Optional<SourceDefinedSymbol> methodSymbol, String variableName, Range range, boolean usage) {
            String methodName = "";
            if (methodSymbol.isPresent()) {
                methodName = methodSymbol.get().getName();
            }
            ReferenceIndexFiller.this.index.addVariableUsage(this.documentContext.getUri(), MdoRefBuilder.getMdoRef(this.documentContext), this.documentContext.getModuleType(), methodName, variableName, range, !usage);
        }

        @ConstructorProperties(value={"documentContext"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public VariableSymbolReferenceIndexFinder(DocumentContext documentContext) {
            this.documentContext = documentContext;
        }
    }
}

