/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.references.model;

import com.github._1c_syntax.bsl.languageserver.references.model.Symbol;
import com.github._1c_syntax.bsl.languageserver.references.model.SymbolOccurrence;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.springframework.stereotype.Component;

@Component
public class SymbolOccurrenceRepository {
    private final Map<Symbol, Set<SymbolOccurrence>> occurrencesToSymbols = new ConcurrentSkipListMap<Symbol, Set<SymbolOccurrence>>();

    public void save(SymbolOccurrence symbolOccurrence) {
        this.occurrencesToSymbols.computeIfAbsent(symbolOccurrence.getSymbol(), symbol -> new ConcurrentSkipListSet()).add(symbolOccurrence);
    }

    public Set<SymbolOccurrence> getAllBySymbol(Symbol symbol) {
        return this.occurrencesToSymbols.getOrDefault(symbol, Collections.emptySet());
    }

    public void deleteAll(Set<SymbolOccurrence> symbolOccurrences) {
        symbolOccurrences.forEach(symbolOccurrence -> this.occurrencesToSymbols.get(symbolOccurrence.getSymbol()).remove(symbolOccurrence));
    }
}

