/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.utils;

import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.Tree;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.util.Positions;

public final class Trees {
    private static final Set<Integer> VALID_TOKEN_TYPES_FOR_COMMENTS_SEARCH = Set.of(Integer.valueOf(116), Integer.valueOf(113), Integer.valueOf(114), Integer.valueOf(115), Integer.valueOf(117), Integer.valueOf(122), Integer.valueOf(123), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(23));

    public static Collection<ParseTree> findAllRuleNodes(ParseTree t, int ruleIndex) {
        return org.antlr.v4.runtime.tree.Trees.findAllRuleNodes((ParseTree)t, (int)ruleIndex);
    }

    public static List<Tree> getChildren(Tree t) {
        return org.antlr.v4.runtime.tree.Trees.getChildren((Tree)t);
    }

    public static List<Token> getTokens(ParseTree tree) {
        if (tree instanceof BSLParserRuleContext) {
            BSLParserRuleContext parserRuleContext = (BSLParserRuleContext)tree;
            return parserRuleContext.getTokens();
        }
        if (tree instanceof TerminalNode) {
            TerminalNode node = (TerminalNode)tree;
            Token token = node.getSymbol();
            return List.of(token);
        }
        if (tree.getChildCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Token> results = new ArrayList<Token>();
        Trees.getTokensFromParseTree(tree, results);
        return Collections.unmodifiableList(results);
    }

    private static void getTokensFromParseTree(ParseTree tree, List<Token> tokens) {
        for (int i = 0; i < tree.getChildCount(); ++i) {
            ParseTree child = tree.getChild(i);
            if (child instanceof TerminalNode) {
                TerminalNode node = (TerminalNode)child;
                Token token = node.getSymbol();
                tokens.add(token);
                continue;
            }
            Trees.getTokensFromParseTree(child, tokens);
        }
    }

    public static Collection<ParseTree> findAllTokenNodes(ParseTree t, int ttype) {
        return org.antlr.v4.runtime.tree.Trees.findAllTokenNodes((ParseTree)t, (int)ttype);
    }

    public static List<ParseTree> getDescendants(ParseTree t) {
        ArrayList<ParseTree> nodes = new ArrayList<ParseTree>(t.getChildCount());
        Trees.flatten(t, nodes);
        return nodes;
    }

    private static void flatten(ParseTree t, List<ParseTree> flatList) {
        flatList.add(t);
        int n = t.getChildCount();
        for (int i = 0; i < n; ++i) {
            Trees.flatten(t.getChild(i), flatList);
        }
    }

    private static int getRuleIndex(ParseTree node) {
        if (node instanceof TerminalNode) {
            TerminalNode terminalNode = (TerminalNode)node;
            return terminalNode.getSymbol().getType();
        }
        return ((BSLParserRuleContext)node).getRuleIndex();
    }

    private static List<ParseTree> getDescendantsWithFilter(ParseTree parent, ParseTree tnc, int ruleindex) {
        List<ParseTree> descendants = Trees.getRuleIndex(tnc) == ruleindex ? new ArrayList<ParseTree>(org.antlr.v4.runtime.tree.Trees.findAllRuleNodes((ParseTree)parent, (int)ruleindex)) : org.antlr.v4.runtime.tree.Trees.getDescendants((ParseTree)parent).stream().filter(BSLParserRuleContext.class::isInstance).filter(node -> node.equals(tnc) || Trees.getRuleIndex(node) == ruleindex).toList();
        return descendants;
    }

    @Nullable
    public static BSLParserRuleContext getAncestorByRuleIndex(BSLParserRuleContext element, int type) {
        BSLParserRuleContext parent = element.getParent();
        if (parent == null) {
            return null;
        }
        if (parent.getRuleIndex() == type) {
            return parent;
        }
        return Trees.getAncestorByRuleIndex(parent, type);
    }

    public static boolean treeContainsErrors(ParseTree tnc) {
        return Trees.treeContainsErrors(tnc, true);
    }

    public static boolean nodeContainsErrors(ParseTree tnc) {
        return Trees.treeContainsErrors(tnc, false);
    }

    public static ParseTree getPreviousNode(ParseTree parent, ParseTree tnc, int ruleindex) {
        List<ParseTree> descendants = Trees.getDescendantsWithFilter(parent, tnc, ruleindex);
        int pos = descendants.indexOf(tnc);
        if (pos > 0) {
            return descendants.get(pos - 1);
        }
        return tnc;
    }

    public static Optional<Token> getPreviousTokenFromDefaultChannel(List<Token> tokens, int tokenIndex, int tokenType) {
        Token token;
        while (true) {
            if (tokenIndex == 0) {
                return Optional.empty();
            }
            token = tokens.get(tokenIndex);
            if (token.getChannel() == 0 && token.getType() == tokenType) break;
            --tokenIndex;
        }
        return Optional.of(token);
    }

    public static Optional<Token> getPreviousTokenFromDefaultChannel(List<Token> tokens, int tokenIndex) {
        Token token;
        while (true) {
            if (tokenIndex == 0) {
                return Optional.empty();
            }
            token = tokens.get(tokenIndex);
            if (token.getChannel() == 0) break;
            --tokenIndex;
        }
        return Optional.of(token);
    }

    public static ParseTree getNextNode(ParseTree parent, ParseTree tnc, int ruleindex) {
        List<ParseTree> descendants = Trees.getDescendantsWithFilter(parent, tnc, ruleindex);
        int pos = descendants.indexOf(tnc);
        if (pos + 1 < descendants.size()) {
            return descendants.get(pos + 1);
        }
        return tnc;
    }

    public static BSLParserRuleContext getRootParent(BSLParserRuleContext tnc) {
        if (tnc.getParent() != null) {
            return Trees.getRootParent(tnc.getParent());
        }
        return tnc;
    }

    @Nullable
    public static BSLParserRuleContext getRootParent(BSLParserRuleContext tnc, int ruleindex) {
        BSLParserRuleContext parent = tnc.getParent();
        if (parent == null) {
            return null;
        }
        if (Trees.getRuleIndex((ParseTree)parent) == ruleindex) {
            return parent;
        }
        return Trees.getRootParent(parent, ruleindex);
    }

    @Nullable
    public static BSLParserRuleContext getRootParent(BSLParserRuleContext tnc, Collection<Integer> indexes) {
        BSLParserRuleContext parent = tnc.getParent();
        if (parent == null) {
            return null;
        }
        if (indexes.contains(Trees.getRuleIndex((ParseTree)parent))) {
            return parent;
        }
        return Trees.getRootParent(parent, indexes);
    }

    public static List<BSLParserRuleContext> getChildren(Tree t, Integer ... ruleIndex) {
        return Trees.getChildrenStream(t, ruleIndex).collect(Collectors.toList());
    }

    public static Optional<BSLParserRuleContext> getFirstChild(Tree t, Integer ... ruleIndex) {
        return Trees.getChildrenStream(t, ruleIndex).findFirst();
    }

    private static Stream<BSLParserRuleContext> getChildrenStream(Tree t, Integer[] ruleIndex) {
        List<Integer> indexes = Arrays.asList(ruleIndex);
        return IntStream.range(0, t.getChildCount()).mapToObj(arg_0 -> ((Tree)t).getChild(arg_0)).filter(child -> {
            BSLParserRuleContext rule;
            return child instanceof BSLParserRuleContext && indexes.contains((rule = (BSLParserRuleContext)child).getRuleIndex());
        }).map(BSLParserRuleContext.class::cast);
    }

    public static Collection<ParserRuleContext> findAllRuleNodes(ParseTree t, Integer ... index) {
        return Trees.findAllRuleNodes(t, Arrays.asList(index));
    }

    public static Collection<ParserRuleContext> findAllRuleNodes(ParseTree t, Collection<Integer> indexes) {
        ParserRuleContext parserRuleContext;
        ArrayList<ParserRuleContext> nodes = new ArrayList<ParserRuleContext>();
        if (t instanceof ParserRuleContext && indexes.contains((parserRuleContext = (ParserRuleContext)t).getRuleIndex())) {
            nodes.add((ParserRuleContext)t);
        }
        IntStream.range(0, t.getChildCount()).mapToObj(i -> Trees.findAllRuleNodes(t.getChild(i), indexes)).forEachOrdered(nodes::addAll);
        return nodes;
    }

    public static Collection<ParserRuleContext> findAllTopLevelDescendantNodes(ParserRuleContext root, Collection<Integer> indexes) {
        ArrayList<ParserRuleContext> result = new ArrayList<ParserRuleContext>();
        root.children.stream().map(node -> Trees.findAllTopLevelDescendantNodesInner(node, indexes)).forEach(result::addAll);
        return result;
    }

    private static Collection<ParserRuleContext> findAllTopLevelDescendantNodesInner(ParseTree root, Collection<Integer> indexes) {
        ParserRuleContext rule;
        if (root instanceof ParserRuleContext && indexes.contains((rule = (ParserRuleContext)root).getRuleIndex())) {
            return List.of(rule);
        }
        ArrayList<ParserRuleContext> result = new ArrayList<ParserRuleContext>();
        IntStream.range(0, root.getChildCount()).mapToObj(i -> Trees.findAllTopLevelDescendantNodesInner(root.getChild(i), indexes)).forEachOrdered(result::addAll);
        return result;
    }

    public static boolean nodeContains(ParseTree t, Integer ... index) {
        ParserRuleContext rule;
        HashSet<Integer> indexes = new HashSet<Integer>(Arrays.asList(index));
        if (t instanceof ParserRuleContext && indexes.contains((rule = (ParserRuleContext)t).getRuleIndex())) {
            return true;
        }
        return IntStream.range(0, t.getChildCount()).anyMatch(i -> Trees.nodeContains(t.getChild(i), index));
    }

    public static boolean nodeContains(ParseTree t, ParseTree exclude, Integer ... index) {
        HashSet<Integer> indexes = new HashSet<Integer>(Arrays.asList(index));
        if (t instanceof ParserRuleContext) {
            ParserRuleContext rule = (ParserRuleContext)t;
            if (!t.equals(exclude) && indexes.contains(rule.getRuleIndex())) {
                return true;
            }
        }
        return IntStream.range(0, t.getChildCount()).anyMatch(i -> Trees.nodeContains(t.getChild(i), exclude, index));
    }

    public static Optional<TerminalNode> findTerminalNodeContainsPosition(BSLParserRuleContext tree, Position position) {
        if (tree.getTokens().isEmpty()) {
            return Optional.empty();
        }
        Token start = tree.getStart();
        Token stop = tree.getStop();
        if (!Trees.positionIsAfterOrOnToken(position, start) || !Trees.positionIsBeforeOrOnToken(position, stop)) {
            return Optional.empty();
        }
        List<Tree> children = Trees.getChildren((Tree)tree);
        for (Tree child : children) {
            if (child instanceof TerminalNode) {
                TerminalNode terminalNode = (TerminalNode)child;
                Token token = terminalNode.getSymbol();
                if (!Trees.tokenContainsPosition(token, position)) continue;
                return Optional.of(terminalNode);
            }
            Optional<TerminalNode> node = Trees.findTerminalNodeContainsPosition((BSLParserRuleContext)child, position);
            if (!node.isPresent()) continue;
            return node;
        }
        return Optional.empty();
    }

    public static Optional<Token> getTrailingComment(List<Token> tokens, Token token) {
        Token nextToken;
        int index = token.getTokenIndex();
        int size = tokens.size();
        int line = token.getLine();
        for (int currentIndex = index + 1; currentIndex < size && (nextToken = tokens.get(currentIndex)).getLine() <= line; ++currentIndex) {
            if (nextToken.getType() != 1) continue;
            return Optional.of(nextToken);
        }
        return Optional.empty();
    }

    public static List<Token> getComments(List<Token> tokens, Token token) {
        ArrayList<Token> comments = new ArrayList<Token>();
        Trees.fillCommentsCollection(tokens, token, comments);
        return comments;
    }

    private static void fillCommentsCollection(List<Token> tokens, Token currentToken, List<Token> lines) {
        int index = currentToken.getTokenIndex();
        if (index == 0) {
            return;
        }
        Token previousToken = tokens.get(index - 1);
        if (Trees.abortSearchComments(previousToken, currentToken)) {
            return;
        }
        Trees.fillCommentsCollection(tokens, previousToken, lines);
        int type = previousToken.getType();
        if (type == 1) {
            lines.add(previousToken);
        }
    }

    private static boolean abortSearchComments(Token previousToken, Token currentToken) {
        int type = previousToken.getType();
        return !VALID_TOKEN_TYPES_FOR_COMMENTS_SEARCH.contains(type) || Trees.isBlankLine(previousToken, currentToken);
    }

    private static boolean isBlankLine(Token previousToken, Token currentToken) {
        return previousToken.getType() == 2 && (previousToken.getTokenIndex() == 0 || previousToken.getLine() + 1 != currentToken.getLine());
    }

    private static boolean treeContainsErrors(ParseTree tnc, boolean recursive) {
        if (!(tnc instanceof BSLParserRuleContext)) {
            return false;
        }
        BSLParserRuleContext ruleContext = (BSLParserRuleContext)tnc;
        if (ruleContext.exception != null) {
            return true;
        }
        return recursive && ruleContext.children != null && ruleContext.children.stream().anyMatch(Trees::treeContainsErrors);
    }

    private static boolean tokenContainsPosition(Token token, Position position) {
        Range tokenRange = Ranges.create(token);
        return Ranges.containsPosition(tokenRange, position);
    }

    private static boolean positionIsBeforeOrOnToken(Position position, Token token) {
        Range tokenRange = Ranges.create(token);
        Position end = tokenRange.getEnd();
        return Positions.isBefore((Position)position, (Position)end) || end.equals((Object)position);
    }

    private static boolean positionIsAfterOrOnToken(Position position, Token token) {
        Range tokenRange = Ranges.create(token);
        Position start = tokenRange.getStart();
        return Positions.isBefore((Position)start, (Position)position) || start.equals((Object)position);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Trees() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

