# Назначение псевдонимов выбранным полям в запросе (AssignAliasFieldsInQuery)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                       Теги                       |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:------------------------------------------------:|
| `Дефект кода` |             `BSL`             | `Важный` |              `Да`              |                 `1`                 |       `standard`<br>`sql`<br>`badpractice`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Рекомендуется указывать и необязательные конструкции запроса, прежде всего - явно назначать псевдонимы полям, в целях повышения наглядности текста запроса и "устойчивости" использующего его кода.  
Например, если в алгоритме используется запрос с полем, объявленным как

```bsl
Касса.Валюта
```
при изменении имени реквизита нужно будет также изменить и код, осуществляющий обращение по имени свойства Валюта к выборке из результата запроса. Если же поле будет объявлено как

```bsl
Касса.Валюта КАК Валюта
```
то изменение имени реквизита приведет только к изменению текста запроса.

Особенно внимательно следует относиться к автоматически присваиваемым псевдонимам для полей – реквизитов других полей, типа "... Касса.Валюта.Наименование...". В приведенном выше примере поле получит автоматический псевдоним ВалютаНаименование, а не Наименование.

Следует обязательно указывать ключевое слово КАК перед псевдонимом поля источника.

Псевдонимы таблиц и полей из вторичных запросов из "ОБЪЕДИНИТЬ" диагностикой не проверяются. 

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

```bsl   
    Запрос = Новый Запрос;
    Запрос.Текст =
    "ВЫБРАТЬ
    |	Валюты.Ссылка, // Неправильно
    |	Валюты.Ссылка КАК ПсевдонимПоляСсылка, // Правильно
    |	Валюты.Код Код // Неправильно
    |ИЗ
    |	Справочник.Валюты КАК Валюты // Игнорируется
    |
    |ОБЪЕДИНИТЬ ВСЕ
    |
    |ВЫБРАТЬ
    |	Валюты.Ссылка, // Игнорируется
    |	Валюты.Ссылка, // Игнорируется
    |	Валюты.Код // Игнорируется
    |ИЗ
    |	Справочник.Валюты КАК Валюты // Игнорируется
    |;
    |
    |////////////////////////////////////////////////////////////////////////////////
    |ВЫБРАТЬ
    |	Валюты.Ссылка, // Неправильно
    |	Валюты.Ссылка КАК ПсевдонимПоляСсылка, // Правильно
    |	Валюты.Код Код // Неправильно
    |ИЗ
    |	Справочник.Валюты КАК Валюты // Игнорируется
    |
    |ОБЪЕДИНИТЬ ВСЕ
    |
    |ВЫБРАТЬ
    |	Валюты.Ссылка, // Игнорируется
    |	Валюты.Ссылка, // Игнорируется
    |	Валюты.Код // Игнорируется
    |ИЗ
    |	Справочник.Валюты КАК Валюты"; // Игнорируется
    
    Запрос1 = Новый Запрос;
    Запрос1.Текст =
    "ВЫБРАТЬ
    |	ВложенныйЗапрос.Ссылка КАК Ссылка // Правильно
    |ИЗ
    |	(ВЫБРАТЬ
    |		Валюты.Ссылка // Неправильно
    |	ИЗ
    |		Справочник.Валюты КАК Валюты) КАК ВложенныйЗапрос"; // Игнорируется 
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
Источник: [Оформление текстов запросов](https://its.1c.ru/db/v8std#content:437:hdoc)
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:AssignAliasFieldsInQuery-off
// BSLLS:AssignAliasFieldsInQuery-on
```

### Параметр конфигурационного файла

```json
"AssignAliasFieldsInQuery": false
```
