# Отключение безопасного режима (DisableSafeMode)

|     Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |     Теги     |
|:------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:------------:|
| `Уязвимость` |             `BSL`             | `Важный` |              `Да`              |                `15`                 | `suspicious` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
Помимо программного кода конфигурации, в прикладном решении может исполняться сторонний программный код, который может быть подключен с помощью внешних отчетов, внешних обработок, расширений конфигурации, внешних компонент или другими способами, например, с помощью стороннего (по отношению к конфигурации) программного кода, надежность которого разработчик гарантировать не может (далее – внешний код). При этом злоумышленник может предусмотреть в нем различные деструктивные действия (как в самом внешнем коде, так и опосредовано, через запуск внешних приложений, внешних компонент, COM-объектов), которые могут нанести вред компьютерам пользователей, серверным компьютерам, а также данным в программе.

Перечисленные проблемы безопасности особенно критичны при работе конфигураций в модели сервиса. Например, получив доступ к сервису, вредоносный код может получить доступ сразу ко всем приложениям всех пользователей сервиса.

Поэтому важно контролировать выполнение подобного внешнего кода в безопасном режиме, в исключительных случаях точечно разрешая выполнять код в небезопасном режиме после верификации кода. 

Правило диагностирует вызовы методов ` УстановитьБезопасныйРежим` и `УстановитьОтключениеБезопасногоРежима` в режиме отключения контроля безопасного режима
- вызов `УстановитьБезопасныйРежим (Истина)` игнорируется
- вызов `УстановитьОтключениеБезопасногоРежима(Ложь)` игнорируется

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->
```
    УстановитьБезопасныйРежим (Ложь); // есть замечание

    Значение = Ложь;
    УстановитьБезопасныйРежим (Значение); // есть замечание

    УстановитьБезопасныйРежим (Истина); // нет замечания

    УстановитьОтключениеБезопасногоРежима(Истина); // есть замечание

    Значение = Истина;
    УстановитьОтключениеБезопасногоРежима(Значение); // есть замечание

    УстановитьОтключениеБезопасногоРежима(Ложь); // нет замечания
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->
- [Статья "Безопасный режим работы" - руководство разработчика 1С 8.3.22](https://its.1c.ru/db/v8322doc#bookmark:dev:TI000000186@ee788d9)
- [Стандарт "Ограничение на выполнение «внешнего» кода"](https://its.1c.ru/db/v8std/content/669/hdoc)
- [Стандарт "Безопасность прикладного программного интерфейса сервера"](https://its.1c.ru/db/v8std/content/678/hdoc)
- [Стандарт "Ограничения на использование Выполнить и Вычислить на сервере"](https://its.1c.ru/db/v8std#content:770:hdoc)
- [Стандарт Использование привилегированного режима](https://its.1c.ru/db/v8std/content/485/hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:DisableSafeMode-off
// BSLLS:DisableSafeMode-on
```

### Параметр конфигурационного файла

```json
"DisableSafeMode": false
```
